/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.concurrent.lock.operations;

import com.att.aft.dme2.hazelcast.concurrent.lock.LockResourceImpl;
import com.att.aft.dme2.hazelcast.concurrent.lock.LockStoreImpl;
import com.att.aft.dme2.hazelcast.concurrent.lock.operations.UnlockOperation;
import com.att.aft.dme2.hazelcast.logging.ILogger;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.spi.BackupAwareOperation;
import com.att.aft.dme2.hazelcast.spi.NodeEngine;
import com.att.aft.dme2.hazelcast.spi.Notifier;
import com.att.aft.dme2.hazelcast.spi.ObjectNamespace;
import com.att.aft.dme2.hazelcast.spi.partition.IPartition;
import com.att.aft.dme2.hazelcast.spi.partition.IPartitionService;
import java.io.IOException;

public class LocalLockCleanupOperation
extends UnlockOperation
implements Notifier,
BackupAwareOperation {
    private final String uuid;

    public LocalLockCleanupOperation(ObjectNamespace namespace, Data key, String uuid) {
        super(namespace, key, -1L, true);
        this.uuid = uuid;
    }

    @Override
    public void run() throws Exception {
        LockStoreImpl lockStore = this.getLockStore();
        LockResourceImpl lock = lockStore.getLock(this.key);
        if (this.uuid.equals(lock.getOwner())) {
            ILogger logger = this.getLogger();
            if (logger.isFinestEnabled()) {
                logger.finest("Unlocking lock owned by uuid: " + this.uuid + ", thread-id: " + lock.getThreadId() + ", count: " + lock.getLockCount());
            }
            this.response = lockStore.forceUnlock(this.key);
        }
    }

    @Override
    public boolean shouldBackup() {
        NodeEngine nodeEngine = this.getNodeEngine();
        IPartitionService partitionService = nodeEngine.getPartitionService();
        IPartition partition = partitionService.getPartition(this.getPartitionId());
        return partition.isLocal() && Boolean.TRUE.equals(this.response);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        throw new UnsupportedOperationException();
    }
}

