/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.concurrent.lock.operations;

import com.att.aft.dme2.hazelcast.concurrent.lock.LockStoreImpl;
import com.att.aft.dme2.hazelcast.concurrent.lock.LockWaitNotifyKey;
import com.att.aft.dme2.hazelcast.concurrent.lock.operations.AbstractLockOperation;
import com.att.aft.dme2.hazelcast.concurrent.lock.operations.LockBackupOperation;
import com.att.aft.dme2.hazelcast.core.OperationTimeoutException;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.spi.BackupAwareOperation;
import com.att.aft.dme2.hazelcast.spi.BlockingOperation;
import com.att.aft.dme2.hazelcast.spi.ObjectNamespace;
import com.att.aft.dme2.hazelcast.spi.Operation;
import com.att.aft.dme2.hazelcast.spi.WaitNotifyKey;
import java.io.Serializable;

public class LockOperation
extends AbstractLockOperation
implements BlockingOperation,
BackupAwareOperation {
    public LockOperation() {
    }

    public LockOperation(ObjectNamespace namespace, Data key, long threadId, long leaseTime, long timeout) {
        super(namespace, key, threadId, leaseTime, timeout);
    }

    public LockOperation(ObjectNamespace namespace, Data key, long threadId, long leaseTime, long timeout, long referenceId) {
        super(namespace, key, threadId, leaseTime, timeout);
        this.setReferenceCallId(referenceId);
    }

    @Override
    public void run() throws Exception {
        this.response = this.getLockStore().lock(this.key, this.getCallerUuid(), this.threadId, this.getReferenceCallId(), this.leaseTime);
    }

    @Override
    public Operation getBackupOperation() {
        LockBackupOperation operation = new LockBackupOperation(this.namespace, this.key, this.threadId, this.leaseTime, this.getCallerUuid());
        operation.setReferenceCallId(this.getReferenceCallId());
        return operation;
    }

    @Override
    public boolean shouldBackup() {
        return Boolean.TRUE.equals(this.response);
    }

    @Override
    public final WaitNotifyKey getWaitKey() {
        return new LockWaitNotifyKey(this.namespace, this.key);
    }

    @Override
    public final boolean shouldWait() {
        LockStoreImpl lockStore = this.getLockStore();
        return this.getWaitTimeout() != 0L && !lockStore.canAcquireLock(this.key, this.getCallerUuid(), this.threadId);
    }

    @Override
    public final void onWaitExpire() {
        long timeout = this.getWaitTimeout();
        Serializable response = timeout < 0L || timeout == Long.MAX_VALUE ? new OperationTimeoutException() : Boolean.FALSE;
        this.sendResponse(response);
    }

    @Override
    public int getId() {
        return 8;
    }
}

