/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.concurrent.lock.operations;

import com.att.aft.dme2.hazelcast.concurrent.lock.LockStoreImpl;
import com.att.aft.dme2.hazelcast.concurrent.lock.operations.BaseSignalOperation;
import com.att.aft.dme2.hazelcast.concurrent.lock.operations.SignalBackupOperation;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.spi.BackupAwareOperation;
import com.att.aft.dme2.hazelcast.spi.ObjectNamespace;
import com.att.aft.dme2.hazelcast.spi.Operation;

public class SignalOperation
extends BaseSignalOperation
implements BackupAwareOperation {
    public SignalOperation() {
    }

    public SignalOperation(ObjectNamespace namespace, Data key, long threadId, String conditionId, boolean all) {
        super(namespace, key, threadId, conditionId, all);
    }

    @Override
    public void beforeRun() throws Exception {
        LockStoreImpl lockStore = this.getLockStore();
        boolean isLockOwner = lockStore.isLockedBy(this.key, this.getCallerUuid(), this.threadId);
        this.ensureLockOwner(lockStore, isLockOwner);
    }

    private void ensureLockOwner(LockStoreImpl lockStore, boolean isLockOwner) {
        if (!isLockOwner) {
            String ownerInfo = lockStore.getOwnerInfo(this.key);
            throw new IllegalMonitorStateException("Current thread is not owner of the lock! -> " + ownerInfo);
        }
    }

    @Override
    public boolean shouldBackup() {
        return this.awaitCount > 0;
    }

    @Override
    public Operation getBackupOperation() {
        return new SignalBackupOperation(this.namespace, this.key, this.threadId, this.conditionId, this.all);
    }

    @Override
    public int getId() {
        return 11;
    }
}

