/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.concurrent.lock.operations;

import com.att.aft.dme2.hazelcast.concurrent.lock.LockStoreImpl;
import com.att.aft.dme2.hazelcast.concurrent.lock.operations.AbstractLockOperation;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.spi.BackupOperation;
import com.att.aft.dme2.hazelcast.spi.ObjectNamespace;
import java.io.IOException;

public class UnlockBackupOperation
extends AbstractLockOperation
implements BackupOperation {
    private boolean force;
    private String originalCallerUuid;

    public UnlockBackupOperation() {
    }

    public UnlockBackupOperation(ObjectNamespace namespace, Data key, long threadId, String originalCallerUuid, boolean force) {
        super(namespace, key, threadId);
        this.force = force;
        this.originalCallerUuid = originalCallerUuid;
    }

    @Override
    public void run() throws Exception {
        LockStoreImpl lockStore = this.getLockStore();
        boolean unlocked = this.force ? lockStore.forceUnlock(this.key) : lockStore.unlock(this.key, this.originalCallerUuid, this.threadId, this.getReferenceCallId());
        this.response = unlocked;
        lockStore.pollExpiredAwaitOp(this.key);
    }

    @Override
    public int getId() {
        return 12;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.originalCallerUuid);
        out.writeBoolean(this.force);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.originalCallerUuid = in.readUTF();
        this.force = in.readBoolean();
    }
}

