/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.concurrent.lock.operations;

import com.att.aft.dme2.hazelcast.concurrent.lock.LockStoreImpl;
import com.att.aft.dme2.hazelcast.concurrent.lock.operations.UnlockOperation;
import com.att.aft.dme2.hazelcast.logging.ILogger;
import com.att.aft.dme2.hazelcast.nio.Address;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.spi.NodeEngine;
import com.att.aft.dme2.hazelcast.spi.ObjectNamespace;
import com.att.aft.dme2.hazelcast.spi.partition.IPartition;
import com.att.aft.dme2.hazelcast.spi.partition.IPartitionService;
import java.io.IOException;

public final class UnlockIfLeaseExpiredOperation
extends UnlockOperation {
    private final int version;

    public UnlockIfLeaseExpiredOperation(ObjectNamespace namespace, Data key, int version) {
        super(namespace, key, -1L, true);
        this.version = version;
    }

    @Override
    public void run() throws Exception {
        LockStoreImpl lockStore = this.getLockStore();
        int lockVersion = lockStore.getVersion(this.key);
        ILogger logger = this.getLogger();
        if (this.version == lockVersion) {
            if (logger.isFinestEnabled()) {
                logger.finest("Releasing a lock owned by " + lockStore.getOwnerInfo(this.key) + " after lease timeout!");
            }
            this.forceUnlock();
        } else if (logger.isFinestEnabled()) {
            logger.finest("Won't unlock since lock version is not matching expiration version: " + lockVersion + " vs " + this.version);
        }
    }

    @Override
    public boolean shouldBackup() {
        IPartition partition;
        NodeEngine nodeEngine = this.getNodeEngine();
        IPartitionService partitionService = nodeEngine.getPartitionService();
        Address thisAddress = nodeEngine.getThisAddress();
        if (!thisAddress.equals((partition = partitionService.getPartition(this.getPartitionId())).getOwnerOrNull())) {
            return false;
        }
        return super.shouldBackup();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        throw new UnsupportedOperationException("This operation is intended to be executed on local member only!");
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        throw new UnsupportedOperationException("This operation is intended to be executed on local member only!");
    }
}

