/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.concurrent.semaphore;

import com.att.aft.dme2.hazelcast.concurrent.semaphore.SemaphoreContainer;
import com.att.aft.dme2.hazelcast.concurrent.semaphore.SemaphoreProxy;
import com.att.aft.dme2.hazelcast.concurrent.semaphore.operations.SemaphoreDeadMemberOperation;
import com.att.aft.dme2.hazelcast.concurrent.semaphore.operations.SemaphoreReplicationOperation;
import com.att.aft.dme2.hazelcast.config.SemaphoreConfig;
import com.att.aft.dme2.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.att.aft.dme2.hazelcast.spi.ClientAwareService;
import com.att.aft.dme2.hazelcast.spi.ManagedService;
import com.att.aft.dme2.hazelcast.spi.MemberAttributeServiceEvent;
import com.att.aft.dme2.hazelcast.spi.MembershipAwareService;
import com.att.aft.dme2.hazelcast.spi.MembershipServiceEvent;
import com.att.aft.dme2.hazelcast.spi.MigrationAwareService;
import com.att.aft.dme2.hazelcast.spi.NodeEngine;
import com.att.aft.dme2.hazelcast.spi.Operation;
import com.att.aft.dme2.hazelcast.spi.OperationService;
import com.att.aft.dme2.hazelcast.spi.PartitionMigrationEvent;
import com.att.aft.dme2.hazelcast.spi.PartitionReplicationEvent;
import com.att.aft.dme2.hazelcast.spi.RemoteService;
import com.att.aft.dme2.hazelcast.spi.impl.OperationResponseHandlerFactory;
import com.att.aft.dme2.hazelcast.spi.partition.IPartitionService;
import com.att.aft.dme2.hazelcast.spi.partition.MigrationEndpoint;
import com.att.aft.dme2.hazelcast.util.ConcurrencyUtil;
import com.att.aft.dme2.hazelcast.util.ConstructorFunction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SemaphoreService
implements ManagedService,
MigrationAwareService,
MembershipAwareService,
RemoteService,
ClientAwareService {
    public static final String SERVICE_NAME = "hz:impl:semaphoreService";
    private final ConcurrentMap<String, SemaphoreContainer> containers = new ConcurrentHashMap<String, SemaphoreContainer>();
    private final ConstructorFunction<String, SemaphoreContainer> containerConstructor = new ConstructorFunction<String, SemaphoreContainer>(){

        @Override
        public SemaphoreContainer createNew(String name) {
            SemaphoreConfig config = SemaphoreService.this.nodeEngine.getConfig().findSemaphoreConfig(name);
            IPartitionService partitionService = SemaphoreService.this.nodeEngine.getPartitionService();
            int partitionId = partitionService.getPartitionId(StringPartitioningStrategy.getPartitionKey(name));
            return new SemaphoreContainer(partitionId, new SemaphoreConfig(config));
        }
    };
    private final NodeEngine nodeEngine;

    public SemaphoreService(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
    }

    public SemaphoreContainer getSemaphoreContainer(String name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.containers, name, this.containerConstructor);
    }

    public boolean containsSemaphore(String name) {
        return this.containers.containsKey(name);
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
    }

    @Override
    public void reset() {
        this.containers.clear();
    }

    @Override
    public void shutdown(boolean terminate) {
        this.containers.clear();
    }

    @Override
    public void memberAdded(MembershipServiceEvent event) {
    }

    @Override
    public void memberRemoved(MembershipServiceEvent event) {
        String caller = event.getMember().getUuid();
        this.onOwnerDisconnected(caller);
    }

    @Override
    public void memberAttributeChanged(MemberAttributeServiceEvent event) {
    }

    private void onOwnerDisconnected(String caller) {
        IPartitionService partitionService = this.nodeEngine.getPartitionService();
        OperationService operationService = this.nodeEngine.getOperationService();
        for (String name : this.containers.keySet()) {
            int partitionId = partitionService.getPartitionId(StringPartitioningStrategy.getPartitionKey(name));
            Operation op = new SemaphoreDeadMemberOperation(name, caller).setPartitionId(partitionId).setValidateTarget(false).setOperationResponseHandler(OperationResponseHandlerFactory.createEmptyResponseHandler()).setService(this).setNodeEngine(this.nodeEngine).setServiceName(SERVICE_NAME);
            operationService.executeOperation(op);
        }
    }

    @Override
    public SemaphoreProxy createDistributedObject(String objectId) {
        return new SemaphoreProxy(objectId, this, this.nodeEngine);
    }

    @Override
    public void destroyDistributedObject(String objectId) {
        this.containers.remove(objectId);
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent partitionMigrationEvent) {
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        HashMap<String, SemaphoreContainer> migrationData = new HashMap<String, SemaphoreContainer>();
        for (Map.Entry entry : this.containers.entrySet()) {
            String name = (String)entry.getKey();
            SemaphoreContainer semaphoreContainer = (SemaphoreContainer)entry.getValue();
            if (semaphoreContainer.getPartitionId() != event.getPartitionId() || semaphoreContainer.getTotalBackupCount() < event.getReplicaIndex()) continue;
            migrationData.put(name, semaphoreContainer);
        }
        if (migrationData.isEmpty()) {
            return null;
        }
        return new SemaphoreReplicationOperation(migrationData);
    }

    public void insertMigrationData(Map<String, SemaphoreContainer> migrationData) {
        this.containers.putAll(migrationData);
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
            this.clearSemaphoresHavingLesserBackupCountThan(event.getPartitionId(), event.getNewReplicaIndex());
        }
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.DESTINATION) {
            this.clearSemaphoresHavingLesserBackupCountThan(event.getPartitionId(), event.getCurrentReplicaIndex());
        }
    }

    private void clearSemaphoresHavingLesserBackupCountThan(int partitionId, int thresholdReplicaIndex) {
        Iterator it = this.containers.values().iterator();
        while (it.hasNext()) {
            SemaphoreContainer semaphoreContainer = (SemaphoreContainer)it.next();
            if (semaphoreContainer.getPartitionId() != partitionId || thresholdReplicaIndex >= 0 && thresholdReplicaIndex <= semaphoreContainer.getTotalBackupCount()) continue;
            it.remove();
        }
    }

    @Override
    public void clientDisconnected(String clientUuid) {
        this.onOwnerDisconnected(clientUuid);
    }
}

