/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.concurrent.semaphore.operations;

import com.att.aft.dme2.hazelcast.concurrent.semaphore.SemaphoreContainer;
import com.att.aft.dme2.hazelcast.concurrent.semaphore.SemaphoreWaitNotifyKey;
import com.att.aft.dme2.hazelcast.concurrent.semaphore.operations.ReleaseBackupOperation;
import com.att.aft.dme2.hazelcast.concurrent.semaphore.operations.SemaphoreBackupAwareOperation;
import com.att.aft.dme2.hazelcast.spi.Notifier;
import com.att.aft.dme2.hazelcast.spi.Operation;
import com.att.aft.dme2.hazelcast.spi.WaitNotifyKey;

public class ReleaseOperation
extends SemaphoreBackupAwareOperation
implements Notifier {
    public ReleaseOperation() {
    }

    public ReleaseOperation(String name, int permitCount) {
        super(name, permitCount);
    }

    @Override
    public void run() throws Exception {
        SemaphoreContainer semaphoreContainer = this.getSemaphoreContainer();
        semaphoreContainer.release(this.permitCount, this.getCallerUuid());
        this.response = true;
    }

    @Override
    public boolean shouldNotify() {
        return this.permitCount > 0;
    }

    @Override
    public WaitNotifyKey getNotifiedKey() {
        return new SemaphoreWaitNotifyKey(this.name, "acquire");
    }

    @Override
    public boolean shouldBackup() {
        return this.permitCount > 0;
    }

    @Override
    public Operation getBackupOperation() {
        return new ReleaseBackupOperation(this.name, this.permitCount, this.getCallerUuid());
    }

    @Override
    public int getId() {
        return 11;
    }
}

