/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.concurrent.semaphore.operations;

import com.att.aft.dme2.hazelcast.concurrent.semaphore.SemaphoreContainer;
import com.att.aft.dme2.hazelcast.concurrent.semaphore.SemaphoreService;
import com.att.aft.dme2.hazelcast.concurrent.semaphore.SemaphoreWaitNotifyKey;
import com.att.aft.dme2.hazelcast.concurrent.semaphore.operations.SemaphoreBackupAwareOperation;
import com.att.aft.dme2.hazelcast.concurrent.semaphore.operations.SemaphoreDeadMemberBackupOperation;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.spi.NodeEngine;
import com.att.aft.dme2.hazelcast.spi.Notifier;
import com.att.aft.dme2.hazelcast.spi.Operation;
import com.att.aft.dme2.hazelcast.spi.WaitNotifyKey;
import com.att.aft.dme2.hazelcast.spi.partition.IPartition;
import com.att.aft.dme2.hazelcast.spi.partition.IPartitionService;
import java.io.IOException;

public class SemaphoreDeadMemberOperation
extends SemaphoreBackupAwareOperation
implements Notifier {
    private String firstCaller;

    public SemaphoreDeadMemberOperation() {
    }

    public SemaphoreDeadMemberOperation(String name, String firstCaller) {
        super(name, -1);
        this.firstCaller = firstCaller;
    }

    @Override
    public void run() throws Exception {
        SemaphoreService service = (SemaphoreService)this.getService();
        if (service.containsSemaphore(this.name)) {
            SemaphoreContainer semaphoreContainer = service.getSemaphoreContainer(this.name);
            this.response = semaphoreContainer.memberRemoved(this.firstCaller);
        }
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public boolean shouldBackup() {
        NodeEngine nodeEngine = this.getNodeEngine();
        IPartitionService partitionService = nodeEngine.getPartitionService();
        IPartition partition = partitionService.getPartition(this.getPartitionId());
        return partition.isLocal() && Boolean.TRUE.equals(this.response);
    }

    @Override
    public Operation getBackupOperation() {
        return new SemaphoreDeadMemberBackupOperation(this.name, this.firstCaller);
    }

    @Override
    public boolean shouldNotify() {
        return Boolean.TRUE.equals(this.response);
    }

    @Override
    public WaitNotifyKey getNotifiedKey() {
        return new SemaphoreWaitNotifyKey(this.name, "acquire");
    }

    @Override
    public int getId() {
        return 12;
    }

    @Override
    public void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.firstCaller);
    }

    @Override
    public void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.firstCaller = in.readUTF();
    }
}

