/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.config;

import com.att.aft.dme2.hazelcast.config.ExecutorConfigReadOnly;

public class ExecutorConfig {
    public static final int DEFAULT_POOL_SIZE = 16;
    public static final int DEFAULT_QUEUE_CAPACITY = Integer.MAX_VALUE;
    private String name = "default";
    private int poolSize = 16;
    private int queueCapacity = Integer.MAX_VALUE;
    private boolean statisticsEnabled = true;
    private ExecutorConfigReadOnly readOnly;

    public ExecutorConfig() {
    }

    public ExecutorConfig(String name) {
        this.name = name;
    }

    public ExecutorConfig(String name, int poolSize) {
        this.name = name;
        this.poolSize = poolSize;
    }

    public ExecutorConfig(ExecutorConfig config) {
        this.name = config.name;
        this.poolSize = config.poolSize;
        this.queueCapacity = config.queueCapacity;
        this.statisticsEnabled = config.statisticsEnabled;
    }

    public ExecutorConfigReadOnly getAsReadOnly() {
        if (this.readOnly == null) {
            this.readOnly = new ExecutorConfigReadOnly(this);
        }
        return this.readOnly;
    }

    public String getName() {
        return this.name;
    }

    public ExecutorConfig setName(String name) {
        this.name = name;
        return this;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public ExecutorConfig setPoolSize(int poolSize) {
        if (poolSize <= 0) {
            throw new IllegalArgumentException("poolSize must be positive");
        }
        this.poolSize = poolSize;
        return this;
    }

    public int getQueueCapacity() {
        return this.queueCapacity;
    }

    public ExecutorConfig setQueueCapacity(int queueCapacity) {
        this.queueCapacity = queueCapacity;
        return this;
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public ExecutorConfig setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
        return this;
    }

    public String toString() {
        return "ExecutorConfig{name='" + this.name + '\'' + ", poolSize=" + this.poolSize + ", queueCapacity=" + this.queueCapacity + '}';
    }
}

