/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.config;

import com.att.aft.dme2.hazelcast.config.Config;
import com.att.aft.dme2.hazelcast.config.XmlConfigBuilder;
import com.att.aft.dme2.hazelcast.logging.ILogger;
import com.att.aft.dme2.hazelcast.logging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Properties;

public class FileSystemXmlConfig
extends Config {
    private static final ILogger LOGGER = Logger.getLogger(FileSystemXmlConfig.class);

    public FileSystemXmlConfig(String configFilename) throws FileNotFoundException {
        this(configFilename, System.getProperties());
    }

    public FileSystemXmlConfig(String configFilename, Properties properties) throws FileNotFoundException {
        this(new File(configFilename), properties);
    }

    public FileSystemXmlConfig(File configFile) throws FileNotFoundException {
        this(configFile, System.getProperties());
    }

    public FileSystemXmlConfig(File configFile, Properties properties) throws FileNotFoundException {
        if (configFile == null) {
            throw new IllegalArgumentException("configFile can't be null");
        }
        if (properties == null) {
            throw new IllegalArgumentException("properties can't be null");
        }
        LOGGER.info("Configuring Hazelcast from '" + configFile.getAbsolutePath() + "'.");
        FileInputStream in = new FileInputStream(configFile);
        new XmlConfigBuilder(in).setProperties(properties).build(this);
    }
}

