/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.config;

import com.att.aft.dme2.hazelcast.config.AwsConfig;
import com.att.aft.dme2.hazelcast.config.DiscoveryConfig;
import com.att.aft.dme2.hazelcast.config.DiscoveryStrategyConfig;
import com.att.aft.dme2.hazelcast.config.InvalidConfigurationException;
import com.att.aft.dme2.hazelcast.config.MulticastConfig;
import com.att.aft.dme2.hazelcast.config.TcpIpConfig;
import com.att.aft.dme2.hazelcast.util.Preconditions;
import java.util.Collection;

public class JoinConfig {
    private MulticastConfig multicastConfig = new MulticastConfig();
    private TcpIpConfig tcpIpConfig = new TcpIpConfig();
    private AwsConfig awsConfig = new AwsConfig();
    private DiscoveryConfig discoveryConfig = new DiscoveryConfig();

    public MulticastConfig getMulticastConfig() {
        return this.multicastConfig;
    }

    public JoinConfig setMulticastConfig(MulticastConfig multicastConfig) {
        this.multicastConfig = Preconditions.isNotNull(multicastConfig, "multicastConfig");
        return this;
    }

    public TcpIpConfig getTcpIpConfig() {
        return this.tcpIpConfig;
    }

    public JoinConfig setTcpIpConfig(TcpIpConfig tcpIpConfig) {
        this.tcpIpConfig = Preconditions.isNotNull(tcpIpConfig, "tcpIpConfig");
        return this;
    }

    public AwsConfig getAwsConfig() {
        return this.awsConfig;
    }

    public JoinConfig setAwsConfig(AwsConfig awsConfig) {
        this.awsConfig = Preconditions.isNotNull(awsConfig, "awsConfig");
        return this;
    }

    public DiscoveryConfig getDiscoveryConfig() {
        return this.discoveryConfig;
    }

    public JoinConfig setDiscoveryConfig(DiscoveryConfig discoveryConfig) {
        this.discoveryConfig = Preconditions.isNotNull(discoveryConfig, "discoveryProvidersConfig");
        return this;
    }

    public void verify() {
        if (this.getTcpIpConfig().isEnabled() && this.getMulticastConfig().isEnabled()) {
            throw new InvalidConfigurationException("TCP/IP and Multicast join can't be enabled at the same time");
        }
        if (this.getTcpIpConfig().isEnabled() && this.getAwsConfig().isEnabled()) {
            throw new InvalidConfigurationException("TCP/IP and AWS join can't be enabled at the same time");
        }
        if (this.getMulticastConfig().isEnabled() && this.getAwsConfig().isEnabled()) {
            throw new InvalidConfigurationException("Multicast and AWS join can't be enabled at the same time");
        }
        this.verifyDiscoveryProviderConfig();
    }

    private void verifyDiscoveryProviderConfig() {
        Collection<DiscoveryStrategyConfig> discoveryStrategyConfigs = this.discoveryConfig.getDiscoveryStrategyConfigs();
        if (discoveryStrategyConfigs.size() > 0) {
            if (this.getMulticastConfig().isEnabled()) {
                throw new InvalidConfigurationException("Multicast and DiscoveryProviders join can't be enabled at the same time");
            }
            if (this.getAwsConfig().isEnabled()) {
                throw new InvalidConfigurationException("AWS and DiscoveryProviders join can't be enabled at the same time");
            }
        }
    }

    public String toString() {
        return "JoinConfig{multicastConfig=" + this.multicastConfig + ", tcpIpConfig=" + this.tcpIpConfig + ", awsConfig=" + this.awsConfig + ", discoveryProvidersConfig=" + this.discoveryConfig + '}';
    }
}

