/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.config;

import com.att.aft.dme2.hazelcast.config.ListenerConfigReadOnly;
import com.att.aft.dme2.hazelcast.util.Preconditions;
import java.util.EventListener;

public class ListenerConfig {
    protected String className;
    protected EventListener implementation;
    private ListenerConfigReadOnly readOnly;

    public ListenerConfig() {
    }

    public ListenerConfig(String className) {
        this.setClassName(className);
    }

    public ListenerConfig(ListenerConfig config) {
        this.implementation = config.getImplementation();
        this.className = config.getClassName();
    }

    public ListenerConfig(EventListener implementation) {
        this.implementation = Preconditions.isNotNull(implementation, "implementation");
    }

    public ListenerConfig getAsReadOnly() {
        if (this.readOnly == null) {
            this.readOnly = new ListenerConfigReadOnly(this);
        }
        return this.readOnly;
    }

    public String getClassName() {
        return this.className;
    }

    public ListenerConfig setClassName(String className) {
        this.className = Preconditions.checkHasText(className, "className must contain text");
        this.implementation = null;
        return this;
    }

    public EventListener getImplementation() {
        return this.implementation;
    }

    public ListenerConfig setImplementation(EventListener implementation) {
        this.implementation = Preconditions.isNotNull(implementation, "implementation");
        this.className = null;
        return this;
    }

    public boolean isIncludeValue() {
        return true;
    }

    public boolean isLocal() {
        return false;
    }

    public String toString() {
        return "ListenerConfig [className=" + this.className + ", implementation=" + this.implementation + ", includeValue=" + this.isIncludeValue() + ", local=" + this.isLocal() + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListenerConfig that = (ListenerConfig)o;
        return !(this.className != null ? !this.className.equals(that.className) : that.className != null);
    }

    public int hashCode() {
        return this.className != null ? this.className.hashCode() : 0;
    }
}

