/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.core;

import com.att.aft.dme2.hazelcast.cluster.MemberAttributeOperationType;
import com.att.aft.dme2.hazelcast.core.Cluster;
import com.att.aft.dme2.hazelcast.core.Member;
import com.att.aft.dme2.hazelcast.core.MembershipEvent;
import com.att.aft.dme2.hazelcast.instance.MemberImpl;
import com.att.aft.dme2.hazelcast.nio.IOUtil;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.DataSerializable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Collections;

@SuppressFBWarnings(value={"SE_BAD_FIELD"})
public class MemberAttributeEvent
extends MembershipEvent
implements DataSerializable {
    private MemberAttributeOperationType operationType;
    private String key;
    private Object value;
    private Member member;

    public MemberAttributeEvent() {
        super(null, null, 5, Collections.EMPTY_SET);
    }

    public MemberAttributeEvent(Cluster cluster, Member member, MemberAttributeOperationType operationType, String key, Object value) {
        super(cluster, member, 5, Collections.EMPTY_SET);
        this.member = member;
        this.operationType = operationType;
        this.key = key;
        this.value = value;
    }

    public MemberAttributeOperationType getOperationType() {
        return this.operationType;
    }

    public String getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public Member getMember() {
        return this.member;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.key);
        this.member.writeData(out);
        out.writeByte(this.operationType.getId());
        if (this.operationType == MemberAttributeOperationType.PUT) {
            IOUtil.writeAttributeValue(this.value, out);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.key = in.readUTF();
        this.member = new MemberImpl();
        this.member.readData(in);
        this.operationType = MemberAttributeOperationType.getValue(in.readByte());
        if (this.operationType == MemberAttributeOperationType.PUT) {
            this.value = IOUtil.readAttributeValue(in);
        }
        this.source = this.member;
    }
}

