/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.durableexecutor.impl;

import com.att.aft.dme2.hazelcast.core.DistributedObject;
import com.att.aft.dme2.hazelcast.durableexecutor.impl.DurableExecutorPartitionContainer;
import com.att.aft.dme2.hazelcast.durableexecutor.impl.DurableExecutorServiceProxy;
import com.att.aft.dme2.hazelcast.spi.ManagedService;
import com.att.aft.dme2.hazelcast.spi.MigrationAwareService;
import com.att.aft.dme2.hazelcast.spi.NodeEngine;
import com.att.aft.dme2.hazelcast.spi.Operation;
import com.att.aft.dme2.hazelcast.spi.PartitionMigrationEvent;
import com.att.aft.dme2.hazelcast.spi.PartitionReplicationEvent;
import com.att.aft.dme2.hazelcast.spi.RemoteService;
import com.att.aft.dme2.hazelcast.spi.impl.NodeEngineImpl;
import com.att.aft.dme2.hazelcast.spi.partition.MigrationEndpoint;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class DistributedDurableExecutorService
implements ManagedService,
RemoteService,
MigrationAwareService {
    public static final String SERVICE_NAME = "hz:impl:durableExecutorService";
    private final NodeEngineImpl nodeEngine;
    private final DurableExecutorPartitionContainer[] partitionContainers;
    private final Set<String> shutdownExecutors = Collections.newSetFromMap(new ConcurrentHashMap());

    public DistributedDurableExecutorService(NodeEngineImpl nodeEngine) {
        this.nodeEngine = nodeEngine;
        int partitionCount = nodeEngine.getPartitionService().getPartitionCount();
        this.partitionContainers = new DurableExecutorPartitionContainer[partitionCount];
        for (int partitionId = 0; partitionId < partitionCount; ++partitionId) {
            this.partitionContainers[partitionId] = new DurableExecutorPartitionContainer(nodeEngine, partitionId);
        }
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
    }

    public DurableExecutorPartitionContainer getPartitionContainer(int partitionId) {
        return this.partitionContainers[partitionId];
    }

    public NodeEngine getNodeEngine() {
        return this.nodeEngine;
    }

    @Override
    public void reset() {
        this.shutdownExecutors.clear();
        for (int partitionId = 0; partitionId < this.partitionContainers.length; ++partitionId) {
            this.partitionContainers[partitionId] = new DurableExecutorPartitionContainer(this.nodeEngine, partitionId);
        }
    }

    @Override
    public void shutdown(boolean terminate) {
        this.reset();
    }

    @Override
    public DistributedObject createDistributedObject(String name) {
        return new DurableExecutorServiceProxy(this.nodeEngine, this, name);
    }

    @Override
    public void destroyDistributedObject(String name) {
        this.shutdownExecutors.remove(name);
        this.nodeEngine.getExecutionService().shutdownDurableExecutor(name);
    }

    public void shutdownExecutor(String name) {
        this.nodeEngine.getExecutionService().shutdownDurableExecutor(name);
        this.shutdownExecutors.add(name);
    }

    public boolean isShutdown(String name) {
        return this.shutdownExecutors.contains(name);
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        int partitionId = event.getPartitionId();
        DurableExecutorPartitionContainer partitionContainer = this.partitionContainers[partitionId];
        return partitionContainer.prepareReplicationOperation(event.getReplicaIndex());
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent event) {
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        int partitionId = event.getPartitionId();
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
            this.clearRingBuffersHavingLesserBackupCountThan(partitionId, event.getNewReplicaIndex());
        } else if (event.getNewReplicaIndex() == 0) {
            DurableExecutorPartitionContainer partitionContainer = this.partitionContainers[partitionId];
            partitionContainer.executeAll();
        }
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.DESTINATION) {
            this.clearRingBuffersHavingLesserBackupCountThan(event.getPartitionId(), event.getCurrentReplicaIndex());
        }
    }

    private void clearRingBuffersHavingLesserBackupCountThan(int partitionId, int thresholdReplicaIndex) {
        DurableExecutorPartitionContainer partitionContainer = this.partitionContainers[partitionId];
        partitionContainer.clearRingBuffersHavingLesserBackupCountThan(thresholdReplicaIndex);
    }
}

