/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.durableexecutor.impl.operations;

import com.att.aft.dme2.hazelcast.durableexecutor.impl.operations.AbstractDurableExecutorOperation;
import com.att.aft.dme2.hazelcast.durableexecutor.impl.operations.DurableExecutorWaitNotifyKey;
import com.att.aft.dme2.hazelcast.nio.Bits;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.spi.Notifier;
import com.att.aft.dme2.hazelcast.spi.WaitNotifyKey;
import java.io.IOException;

public class PutResultOperation
extends AbstractDurableExecutorOperation
implements Notifier {
    private int sequence;
    private Object result;

    public PutResultOperation() {
    }

    public PutResultOperation(String name, int sequence, Object result) {
        super(name);
        this.sequence = sequence;
        this.result = result;
    }

    @Override
    public void run() throws Exception {
        this.getExecutorContainer().putResult(this.sequence, this.result);
    }

    @Override
    public boolean shouldNotify() {
        return true;
    }

    @Override
    public WaitNotifyKey getNotifiedKey() {
        long uniqueId = Bits.combineToLong(this.getPartitionId(), this.sequence);
        return new DurableExecutorWaitNotifyKey(this.name, uniqueId);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.sequence);
        out.writeObject(this.result);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.sequence = in.readInt();
        this.result = in.readObject();
    }
}

