/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.durableexecutor.impl.operations;

import com.att.aft.dme2.hazelcast.core.HazelcastException;
import com.att.aft.dme2.hazelcast.durableexecutor.impl.DurableExecutorContainer;
import com.att.aft.dme2.hazelcast.durableexecutor.impl.operations.AbstractDurableExecutorOperation;
import com.att.aft.dme2.hazelcast.durableexecutor.impl.operations.DurableExecutorWaitNotifyKey;
import com.att.aft.dme2.hazelcast.nio.Bits;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.spi.BlockingOperation;
import com.att.aft.dme2.hazelcast.spi.WaitNotifyKey;
import java.io.IOException;

public class RetrieveResultOperation
extends AbstractDurableExecutorOperation
implements BlockingOperation {
    private int sequence;
    private transient Object result;

    public RetrieveResultOperation() {
    }

    public RetrieveResultOperation(String name, int sequence) {
        super(name);
        this.sequence = sequence;
    }

    @Override
    public void run() throws Exception {
        DurableExecutorContainer executorContainer = this.getExecutorContainer();
        this.result = executorContainer.retrieveResult(this.sequence);
    }

    @Override
    public Object getResponse() {
        return this.result;
    }

    @Override
    public WaitNotifyKey getWaitKey() {
        long uniqueId = Bits.combineToLong(this.getPartitionId(), this.sequence);
        return new DurableExecutorWaitNotifyKey(this.name, uniqueId);
    }

    @Override
    public boolean shouldWait() {
        DurableExecutorContainer executorContainer = this.getExecutorContainer();
        return executorContainer.shouldWait(this.sequence);
    }

    @Override
    public void onWaitExpire() {
        this.sendResponse(new HazelcastException());
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.sequence);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.sequence = in.readInt();
    }
}

