/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.instance;

import com.att.aft.dme2.hazelcast.cluster.Joiner;
import com.att.aft.dme2.hazelcast.instance.AddressPicker;
import com.att.aft.dme2.hazelcast.instance.DefaultAddressPicker;
import com.att.aft.dme2.hazelcast.instance.Node;
import com.att.aft.dme2.hazelcast.instance.NodeContext;
import com.att.aft.dme2.hazelcast.instance.NodeExtension;
import com.att.aft.dme2.hazelcast.instance.NodeExtensionFactory;
import com.att.aft.dme2.hazelcast.nio.ConnectionManager;
import com.att.aft.dme2.hazelcast.nio.IOService;
import com.att.aft.dme2.hazelcast.nio.NodeIOService;
import com.att.aft.dme2.hazelcast.nio.tcp.IOThreadingModel;
import com.att.aft.dme2.hazelcast.nio.tcp.TcpIpConnectionManager;
import com.att.aft.dme2.hazelcast.nio.tcp.nonblocking.NonBlockingIOThreadingModel;
import com.att.aft.dme2.hazelcast.nio.tcp.spinning.SpinningIOThreadingModel;
import com.att.aft.dme2.hazelcast.spi.annotation.PrivateApi;
import java.nio.channels.ServerSocketChannel;

@PrivateApi
public class DefaultNodeContext
implements NodeContext {
    @Override
    public NodeExtension createNodeExtension(Node node) {
        return NodeExtensionFactory.create(node);
    }

    @Override
    public AddressPicker createAddressPicker(Node node) {
        return new DefaultAddressPicker(node);
    }

    @Override
    public Joiner createJoiner(Node node) {
        return node.createJoiner();
    }

    @Override
    public ConnectionManager createConnectionManager(Node node, ServerSocketChannel serverSocketChannel) {
        NodeIOService ioService = new NodeIOService(node, node.nodeEngine);
        IOThreadingModel ioThreadingModel = this.createTcpIpConnectionThreadingModel(node, ioService);
        return new TcpIpConnectionManager((IOService)ioService, serverSocketChannel, node.loggingService, node.nodeEngine.getMetricsRegistry(), ioThreadingModel);
    }

    private IOThreadingModel createTcpIpConnectionThreadingModel(Node node, NodeIOService ioService) {
        boolean spinning = Boolean.getBoolean("hazelcast.io.spinning");
        if (spinning) {
            return new SpinningIOThreadingModel(ioService, node.loggingService, node.nodeEngine.getMetricsRegistry(), node.getHazelcastThreadGroup());
        }
        return new NonBlockingIOThreadingModel(ioService, node.loggingService, node.nodeEngine.getMetricsRegistry(), node.getHazelcastThreadGroup());
    }
}

