/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.instance;

import com.att.aft.dme2.hazelcast.cache.impl.CacheService;
import com.att.aft.dme2.hazelcast.cache.impl.ICacheService;
import com.att.aft.dme2.hazelcast.cluster.ClusterState;
import com.att.aft.dme2.hazelcast.config.Config;
import com.att.aft.dme2.hazelcast.config.SerializationConfig;
import com.att.aft.dme2.hazelcast.core.PartitioningStrategy;
import com.att.aft.dme2.hazelcast.instance.BuildInfo;
import com.att.aft.dme2.hazelcast.instance.HazelcastInstanceImpl;
import com.att.aft.dme2.hazelcast.instance.Node;
import com.att.aft.dme2.hazelcast.instance.NodeExtension;
import com.att.aft.dme2.hazelcast.internal.serialization.InternalSerializationService;
import com.att.aft.dme2.hazelcast.internal.serialization.impl.DefaultSerializationServiceBuilder;
import com.att.aft.dme2.hazelcast.logging.ILogger;
import com.att.aft.dme2.hazelcast.map.impl.MapService;
import com.att.aft.dme2.hazelcast.map.impl.MapServiceConstructor;
import com.att.aft.dme2.hazelcast.memory.DefaultMemoryStats;
import com.att.aft.dme2.hazelcast.memory.MemoryStats;
import com.att.aft.dme2.hazelcast.nio.ClassLoaderUtil;
import com.att.aft.dme2.hazelcast.nio.IOService;
import com.att.aft.dme2.hazelcast.nio.MemberSocketInterceptor;
import com.att.aft.dme2.hazelcast.nio.tcp.DefaultSocketChannelWrapperFactory;
import com.att.aft.dme2.hazelcast.nio.tcp.MemberReadHandler;
import com.att.aft.dme2.hazelcast.nio.tcp.MemberWriteHandler;
import com.att.aft.dme2.hazelcast.nio.tcp.ReadHandler;
import com.att.aft.dme2.hazelcast.nio.tcp.SocketChannelWrapperFactory;
import com.att.aft.dme2.hazelcast.nio.tcp.TcpIpConnection;
import com.att.aft.dme2.hazelcast.nio.tcp.WriteHandler;
import com.att.aft.dme2.hazelcast.partition.strategy.DefaultPartitioningStrategy;
import com.att.aft.dme2.hazelcast.security.SecurityContext;
import com.att.aft.dme2.hazelcast.spi.NodeEngine;
import com.att.aft.dme2.hazelcast.spi.annotation.PrivateApi;
import com.att.aft.dme2.hazelcast.spi.impl.NodeEngineImpl;
import com.att.aft.dme2.hazelcast.spi.properties.GroupProperty;
import com.att.aft.dme2.hazelcast.util.ConstructorFunction;
import com.att.aft.dme2.hazelcast.util.ExceptionUtil;
import com.att.aft.dme2.hazelcast.wan.WanReplicationService;
import com.att.aft.dme2.hazelcast.wan.impl.WanReplicationServiceImpl;
import java.util.Collections;
import java.util.Map;

@PrivateApi
public class DefaultNodeExtension
implements NodeExtension {
    protected final Node node;
    protected final ILogger logger;
    protected final ILogger systemLogger;
    private final MemoryStats memoryStats = new DefaultMemoryStats();

    public DefaultNodeExtension(Node node) {
        this.node = node;
        this.logger = node.getLogger(NodeExtension.class);
        this.systemLogger = node.getLogger("com.att.aft.dme2.hazelcast.system");
    }

    @Override
    public void beforeStart() {
    }

    @Override
    public void printNodeInfo() {
        BuildInfo buildInfo = this.node.getBuildInfo();
        String build = buildInfo.getBuild();
        String revision = buildInfo.getRevision();
        if (!revision.isEmpty()) {
            build = build + " - " + revision;
        }
        this.systemLogger.info("Hazelcast " + buildInfo.getVersion() + " (" + build + ") starting at " + this.node.getThisAddress());
        this.systemLogger.info("Copyright (c) 2008-2016, Hazelcast, Inc. All Rights Reserved.");
        this.systemLogger.info("Configured Hazelcast Serialization version : " + buildInfo.getSerializationVersion());
    }

    @Override
    public void beforeJoin() {
    }

    @Override
    public void afterStart() {
    }

    @Override
    public boolean isStartCompleted() {
        return this.node.joined();
    }

    @Override
    public SecurityContext getSecurityContext() {
        this.logger.warning("Security features are only available on Hazelcast Enterprise!");
        return null;
    }

    @Override
    public InternalSerializationService createSerializationService() {
        InternalSerializationService ss;
        try {
            Config config = this.node.getConfig();
            ClassLoader configClassLoader = this.node.getConfigClassLoader();
            HazelcastInstanceImpl hazelcastInstance = this.node.hazelcastInstance;
            PartitioningStrategy partitioningStrategy = this.getPartitioningStrategy(configClassLoader);
            DefaultSerializationServiceBuilder builder = new DefaultSerializationServiceBuilder();
            SerializationConfig serializationConfig = config.getSerializationConfig() != null ? config.getSerializationConfig() : new SerializationConfig();
            byte version = (byte)this.node.getProperties().getInteger(GroupProperty.SERIALIZATION_VERSION);
            ss = (InternalSerializationService)builder.setClassLoader(configClassLoader).setConfig(serializationConfig).setManagedContext(hazelcastInstance.managedContext).setPartitioningStrategy(partitioningStrategy).setHazelcastInstance(hazelcastInstance).setVersion(version).build();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        return ss;
    }

    protected PartitioningStrategy getPartitioningStrategy(ClassLoader configClassLoader) throws Exception {
        String partitioningStrategyClassName = this.node.getProperties().getString(GroupProperty.PARTITIONING_STRATEGY_CLASS);
        if (partitioningStrategyClassName != null && partitioningStrategyClassName.length() > 0) {
            return (PartitioningStrategy)ClassLoaderUtil.newInstance(configClassLoader, partitioningStrategyClassName);
        }
        return new DefaultPartitioningStrategy();
    }

    @Override
    public <T> T createService(Class<T> clazz) {
        if (WanReplicationService.class.isAssignableFrom(clazz)) {
            return (T)new WanReplicationServiceImpl(this.node);
        }
        if (ICacheService.class.isAssignableFrom(clazz)) {
            return (T)new CacheService();
        }
        if (MapService.class.isAssignableFrom(clazz)) {
            return this.createMapService();
        }
        throw new IllegalArgumentException("Unknown service class: " + clazz);
    }

    private <T> T createMapService() {
        ConstructorFunction<NodeEngine, MapService> constructor = MapServiceConstructor.getDefaultMapServiceConstructor();
        NodeEngineImpl nodeEngine = this.node.getNodeEngine();
        return (T)constructor.createNew(nodeEngine);
    }

    @Override
    public Map<String, Object> createExtensionServices() {
        return Collections.emptyMap();
    }

    @Override
    public MemberSocketInterceptor getMemberSocketInterceptor() {
        this.logger.warning("SocketInterceptor feature is only available on Hazelcast Enterprise!");
        return null;
    }

    @Override
    public SocketChannelWrapperFactory getSocketChannelWrapperFactory() {
        return new DefaultSocketChannelWrapperFactory();
    }

    @Override
    public ReadHandler createReadHandler(TcpIpConnection connection, IOService ioService) {
        NodeEngineImpl nodeEngine = this.node.nodeEngine;
        return new MemberReadHandler(connection, nodeEngine.getPacketDispatcher());
    }

    @Override
    public WriteHandler createWriteHandler(TcpIpConnection connection, IOService ioService) {
        return new MemberWriteHandler();
    }

    @Override
    public void onThreadStart(Thread thread) {
    }

    @Override
    public void onThreadStop(Thread thread) {
    }

    @Override
    public MemoryStats getMemoryStats() {
        return this.memoryStats;
    }

    @Override
    public void beforeShutdown() {
    }

    @Override
    public void shutdown() {
        this.logger.info("Destroying node NodeExtension.");
    }

    @Override
    public void validateJoinRequest() {
    }

    @Override
    public void onClusterStateChange(ClusterState newState, boolean persistentChange) {
    }

    @Override
    public boolean registerListener(Object listener) {
        return false;
    }

    @Override
    public boolean triggerForceStart() {
        this.logger.warning("Force start is available when hot restart is active!");
        return false;
    }
}

