/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.instance;

import com.att.aft.dme2.hazelcast.config.Config;
import com.att.aft.dme2.hazelcast.config.XmlConfigBuilder;
import com.att.aft.dme2.hazelcast.core.DuplicateInstanceNameException;
import com.att.aft.dme2.hazelcast.core.HazelcastInstance;
import com.att.aft.dme2.hazelcast.core.LifecycleEvent;
import com.att.aft.dme2.hazelcast.core.Member;
import com.att.aft.dme2.hazelcast.instance.DefaultNodeContext;
import com.att.aft.dme2.hazelcast.instance.HazelcastInstanceImpl;
import com.att.aft.dme2.hazelcast.instance.HazelcastInstanceProxy;
import com.att.aft.dme2.hazelcast.instance.MemberImpl;
import com.att.aft.dme2.hazelcast.instance.Node;
import com.att.aft.dme2.hazelcast.instance.NodeContext;
import com.att.aft.dme2.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.att.aft.dme2.hazelcast.internal.jmx.ManagementService;
import com.att.aft.dme2.hazelcast.spi.annotation.PrivateApi;
import com.att.aft.dme2.hazelcast.spi.properties.GroupProperty;
import com.att.aft.dme2.hazelcast.util.EmptyStatement;
import com.att.aft.dme2.hazelcast.util.ExceptionUtil;
import com.att.aft.dme2.hazelcast.util.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

@PrivateApi
public final class HazelcastInstanceFactory {
    private static final int ADDITIONAL_SLEEP_SECONDS_FOR_NON_FIRST_MEMBERS = 4;
    private static final AtomicInteger FACTORY_ID_GEN = new AtomicInteger();
    private static final ConcurrentMap<String, InstanceFuture> INSTANCE_MAP = new ConcurrentHashMap<String, InstanceFuture>(5);

    private HazelcastInstanceFactory() {
    }

    public static Set<HazelcastInstance> getAllHazelcastInstances() {
        HashSet<HazelcastInstance> result = new HashSet<HazelcastInstance>();
        for (InstanceFuture f : INSTANCE_MAP.values()) {
            result.add(f.get());
        }
        return result;
    }

    public static HazelcastInstance getHazelcastInstance(String instanceName) {
        InstanceFuture instanceFuture = (InstanceFuture)INSTANCE_MAP.get(instanceName);
        if (instanceFuture == null) {
            return null;
        }
        try {
            return instanceFuture.get();
        }
        catch (IllegalStateException t) {
            return null;
        }
    }

    public static HazelcastInstance getOrCreateHazelcastInstance(Config config) {
        Preconditions.checkNotNull(config, "config can't be null");
        String name = config.getInstanceName();
        Preconditions.checkHasText(name, "instanceName must contain text");
        InstanceFuture future = (InstanceFuture)INSTANCE_MAP.get(name);
        if (future != null) {
            return future.get();
        }
        future = new InstanceFuture();
        InstanceFuture found = INSTANCE_MAP.putIfAbsent(name, future);
        if (found != null) {
            return found.get();
        }
        try {
            return HazelcastInstanceFactory.constructHazelcastInstance(config, name, new DefaultNodeContext(), future);
        }
        catch (Throwable t) {
            INSTANCE_MAP.remove(name, future);
            future.setFailure(t);
            throw ExceptionUtil.rethrow(t);
        }
    }

    public static HazelcastInstance newHazelcastInstance(Config config) {
        if (config == null) {
            config = new XmlConfigBuilder().build();
        }
        return HazelcastInstanceFactory.newHazelcastInstance(config, config.getInstanceName(), new DefaultNodeContext());
    }

    private static String createInstanceName(Config config) {
        return "_hzInstance_" + FACTORY_ID_GEN.incrementAndGet() + "_" + config.getGroupConfig().getName();
    }

    public static String getInstanceName(String instanceName, Config config) {
        String name = instanceName;
        if (name == null || name.trim().length() == 0) {
            name = HazelcastInstanceFactory.createInstanceName(config);
        }
        return name;
    }

    public static HazelcastInstance newHazelcastInstance(Config config, String instanceName, NodeContext nodeContext) {
        InstanceFuture future;
        String name;
        if (config == null) {
            config = new XmlConfigBuilder().build();
        }
        if (INSTANCE_MAP.putIfAbsent(name = HazelcastInstanceFactory.getInstanceName(instanceName, config), future = new InstanceFuture()) != null) {
            throw new DuplicateInstanceNameException("HazelcastInstance with name '" + name + "' already exists!");
        }
        try {
            return HazelcastInstanceFactory.constructHazelcastInstance(config, name, nodeContext, future);
        }
        catch (Throwable t) {
            INSTANCE_MAP.remove(name, future);
            future.setFailure(t);
            throw ExceptionUtil.rethrow(t);
        }
    }

    public static Set<HazelcastInstanceImpl> getInstanceImpls(Collection<Member> members) {
        HashSet<HazelcastInstanceImpl> set = new HashSet<HazelcastInstanceImpl>();
        for (InstanceFuture future : INSTANCE_MAP.values()) {
            try {
                MemberImpl localMember;
                if (!future.isSet()) continue;
                HazelcastInstanceProxy instanceProxy = future.get();
                HazelcastInstanceImpl impl = instanceProxy.original;
                if (impl == null || !members.contains(localMember = impl.node.getLocalMember())) continue;
                set.add(impl);
            }
            catch (RuntimeException ignored) {
                EmptyStatement.ignore(ignored);
            }
        }
        return set;
    }

    private static HazelcastInstanceProxy newHazelcastProxy(HazelcastInstanceImpl hazelcastInstance) {
        return new HazelcastInstanceProxy(hazelcastInstance);
    }

    private static HazelcastInstanceProxy constructHazelcastInstance(Config config, String instanceName, NodeContext nodeContext, InstanceFuture future) {
        HazelcastInstanceProxy proxy;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (classLoader == null) {
                Thread.currentThread().setContextClassLoader(HazelcastInstanceFactory.class.getClassLoader());
            }
            HazelcastInstanceImpl hazelcastInstance = new HazelcastInstanceImpl(instanceName, config, nodeContext);
            OutOfMemoryErrorDispatcher.registerServer(hazelcastInstance);
            proxy = HazelcastInstanceFactory.newHazelcastProxy(hazelcastInstance);
            Node node = hazelcastInstance.node;
            boolean firstMember = HazelcastInstanceFactory.isFirstMember(node);
            long initialWaitSeconds = node.getProperties().getSeconds(GroupProperty.INITIAL_WAIT_SECONDS);
            if (initialWaitSeconds > 0L) {
                hazelcastInstance.logger.info(String.format("Waiting %d seconds before completing HazelcastInstance startup...", initialWaitSeconds));
                try {
                    TimeUnit.SECONDS.sleep(initialWaitSeconds);
                    if (firstMember) {
                        node.partitionService.firstArrangement();
                    } else {
                        TimeUnit.SECONDS.sleep(4L);
                    }
                }
                catch (InterruptedException ignored) {
                    EmptyStatement.ignore(ignored);
                }
            }
            HazelcastInstanceFactory.awaitMinimalClusterSize(hazelcastInstance, node, firstMember);
            future.set(proxy);
            hazelcastInstance.lifecycleService.fireLifecycleEvent(LifecycleEvent.LifecycleState.STARTED);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        return proxy;
    }

    private static boolean isFirstMember(Node node) {
        Iterator<Member> iterator = node.getClusterService().getMembers().iterator();
        return iterator.hasNext() && iterator.next().localMember();
    }

    private static void awaitMinimalClusterSize(HazelcastInstanceImpl hazelcastInstance, Node node, boolean firstMember) throws InterruptedException {
        int initialMinClusterSize = node.getProperties().getInteger(GroupProperty.INITIAL_MIN_CLUSTER_SIZE);
        while (node.getClusterService().getSize() < initialMinClusterSize) {
            try {
                hazelcastInstance.logger.info("HazelcastInstance waiting for cluster size of " + initialMinClusterSize);
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException ignored) {
                EmptyStatement.ignore(ignored);
            }
        }
        if (initialMinClusterSize > 1) {
            if (firstMember) {
                node.partitionService.firstArrangement();
            } else {
                TimeUnit.SECONDS.sleep(3L);
            }
            hazelcastInstance.logger.info("HazelcastInstance starting after waiting for cluster size of " + initialMinClusterSize);
        }
    }

    public static void shutdownAll() {
        HazelcastInstanceFactory.shutdownAll(false);
    }

    public static void terminateAll() {
        HazelcastInstanceFactory.shutdownAll(true);
    }

    private static void shutdownAll(boolean terminate) {
        LinkedList<HazelcastInstanceProxy> instances = new LinkedList<HazelcastInstanceProxy>();
        for (InstanceFuture future : INSTANCE_MAP.values()) {
            try {
                HazelcastInstanceProxy instanceProxy = future.get();
                instances.add(instanceProxy);
            }
            catch (RuntimeException ignored) {
                EmptyStatement.ignore(ignored);
            }
        }
        INSTANCE_MAP.clear();
        OutOfMemoryErrorDispatcher.clearServers();
        ManagementService.shutdownAll(instances);
        Collections.sort(instances, new Comparator<HazelcastInstanceProxy>(){

            @Override
            public int compare(HazelcastInstanceProxy o1, HazelcastInstanceProxy o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (HazelcastInstanceProxy proxy : instances) {
            if (terminate) {
                proxy.getLifecycleService().terminate();
            } else {
                proxy.getLifecycleService().shutdown();
            }
            proxy.original = null;
        }
    }

    public static Map<MemberImpl, HazelcastInstanceImpl> getInstanceImplMap() {
        HashMap<MemberImpl, HazelcastInstanceImpl> map = new HashMap<MemberImpl, HazelcastInstanceImpl>();
        for (InstanceFuture future : INSTANCE_MAP.values()) {
            try {
                HazelcastInstanceProxy instanceProxy = future.get();
                HazelcastInstanceImpl impl = instanceProxy.original;
                if (impl == null) continue;
                map.put(impl.node.getLocalMember(), impl);
            }
            catch (RuntimeException ignored) {
                EmptyStatement.ignore(ignored);
            }
        }
        return map;
    }

    public static void remove(HazelcastInstanceImpl instance) {
        OutOfMemoryErrorDispatcher.deregisterServer(instance);
        InstanceFuture future = (InstanceFuture)INSTANCE_MAP.remove(instance.getName());
        if (future != null && future.isSet()) {
            future.get().original = null;
        }
        if (INSTANCE_MAP.size() == 0) {
            ManagementService.shutdown(instance.getName());
        }
    }

    private static class InstanceFuture {
        private volatile HazelcastInstanceProxy hz;
        private volatile Throwable throwable;

        private InstanceFuture() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        HazelcastInstanceProxy get() {
            if (this.hz != null) {
                return this.hz;
            }
            boolean restoreInterrupt = false;
            InstanceFuture instanceFuture = this;
            synchronized (instanceFuture) {
                while (this.hz == null && this.throwable == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ignored) {
                        restoreInterrupt = true;
                    }
                }
            }
            if (restoreInterrupt) {
                Thread.currentThread().interrupt();
            }
            if (this.hz != null) {
                return this.hz;
            }
            throw new IllegalStateException(this.throwable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void set(HazelcastInstanceProxy proxy) {
            InstanceFuture instanceFuture = this;
            synchronized (instanceFuture) {
                this.hz = proxy;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setFailure(Throwable throwable) {
            InstanceFuture instanceFuture = this;
            synchronized (instanceFuture) {
                this.throwable = throwable;
                this.notifyAll();
            }
        }

        boolean isSet() {
            return this.hz != null;
        }
    }
}

