/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.instance;

import com.att.aft.dme2.hazelcast.instance.DefaultNodeExtension;
import com.att.aft.dme2.hazelcast.instance.Node;
import com.att.aft.dme2.hazelcast.instance.NodeExtension;
import com.att.aft.dme2.hazelcast.logging.Logger;
import com.att.aft.dme2.hazelcast.spi.annotation.PrivateApi;
import com.att.aft.dme2.hazelcast.util.ExceptionUtil;
import com.att.aft.dme2.hazelcast.util.ServiceLoader;
import java.lang.reflect.Constructor;
import java.util.Iterator;

@PrivateApi
public final class NodeExtensionFactory {
    private static final String FACTORY_ID = "com.att.aft.dme2.hazelcast.instance.NodeExtension";

    private NodeExtensionFactory() {
    }

    public static NodeExtension create(Node node) {
        try {
            ClassLoader classLoader = node.getConfigClassLoader();
            Iterator iter = ServiceLoader.classIterator(FACTORY_ID, classLoader);
            while (iter.hasNext()) {
                Class clazz = iter.next();
                if (clazz.equals(DefaultNodeExtension.class)) continue;
                if (clazz.getName().equals(DefaultNodeExtension.class.getName())) {
                    Logger.getLogger(NodeExtensionFactory.class).warning("DefaultNodeExtension class has been loaded by two different class-loaders. Are you running Hazelcast in an OSGi environment? If so, set the bundle class-loader in the Config using the setClassloader() method");
                }
                Constructor constructor = clazz.getDeclaredConstructor(Node.class);
                return (NodeExtension)constructor.newInstance(node);
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        return new DefaultNodeExtension(node);
    }
}

