/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.internal.ascii.memcache;

import com.att.aft.dme2.hazelcast.internal.ascii.AbstractTextCommand;
import com.att.aft.dme2.hazelcast.internal.ascii.TextCommandConstants;
import com.att.aft.dme2.hazelcast.internal.ascii.memcache.MemcacheEntry;
import com.att.aft.dme2.hazelcast.nio.IOUtil;
import java.nio.ByteBuffer;

public class GetCommand
extends AbstractTextCommand {
    protected final String key;
    private ByteBuffer value;
    private ByteBuffer lastOne;

    public GetCommand(TextCommandConstants.TextCommandType type, String key) {
        super(type);
        this.key = key;
    }

    public GetCommand(String key) {
        this(TextCommandConstants.TextCommandType.GET, key);
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public boolean readFrom(ByteBuffer src) {
        return true;
    }

    public void setValue(MemcacheEntry entry, boolean singleGet) {
        if (entry != null) {
            this.value = entry.toNewBuffer();
        }
        this.lastOne = singleGet ? ByteBuffer.wrap(TextCommandConstants.END) : null;
    }

    @Override
    public boolean writeTo(ByteBuffer dst) {
        if (this.value != null) {
            IOUtil.copyToHeapBuffer(this.value, dst);
        }
        if (this.lastOne != null) {
            IOUtil.copyToHeapBuffer(this.lastOne, dst);
        }
        return !(this.value != null && this.value.hasRemaining() || this.lastOne != null && this.lastOne.hasRemaining());
    }

    @Override
    public String toString() {
        return "GetCommand{key='" + this.key + ", value=" + this.value + '\'' + "} " + super.toString();
    }
}

