/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.internal.ascii.rest;

import com.att.aft.dme2.hazelcast.internal.ascii.NoOpCommand;
import com.att.aft.dme2.hazelcast.internal.ascii.TextCommandConstants;
import com.att.aft.dme2.hazelcast.internal.ascii.rest.HttpCommand;
import com.att.aft.dme2.hazelcast.nio.IOUtil;
import com.att.aft.dme2.hazelcast.nio.ascii.TextReadHandler;
import com.att.aft.dme2.hazelcast.util.StringUtil;
import java.nio.ByteBuffer;

public class HttpPostCommand
extends HttpCommand {
    private static final int RADIX = 16;
    private static final int CAPACITY = 500;
    boolean nextLine;
    boolean readyToReadData;
    private ByteBuffer data;
    private ByteBuffer line = ByteBuffer.allocate(500);
    private String contentType;
    private final TextReadHandler readHandler;
    private boolean chunked;

    public HttpPostCommand(TextReadHandler readHandler, String uri) {
        super(TextCommandConstants.TextCommandType.HTTP_POST, uri);
        this.readHandler = readHandler;
    }

    @Override
    public boolean readFrom(ByteBuffer src) {
        boolean complete = this.doActualRead(src);
        while (!complete && this.readyToReadData && this.chunked && src.hasRemaining()) {
            complete = this.doActualRead(src);
        }
        if (complete && this.data != null) {
            this.data.flip();
        }
        return complete;
    }

    public byte[] getData() {
        if (this.data == null) {
            return null;
        }
        return this.data.array();
    }

    public byte[] getContentType() {
        if (this.contentType == null) {
            return null;
        }
        return StringUtil.stringToBytes(this.contentType);
    }

    private void dataNullCheck(int dataSize) {
        if (this.data != null) {
            ByteBuffer newData = ByteBuffer.allocate(this.data.capacity() + dataSize);
            newData.put(this.data.array());
            this.data = newData;
        } else {
            this.data = ByteBuffer.allocate(dataSize);
        }
    }

    private void setReadyToReadData(ByteBuffer cb) {
        while (!this.readyToReadData && cb.hasRemaining()) {
            byte b = cb.get();
            char c = (char)b;
            if (c == '\n') {
                this.processLine(StringUtil.lowerCaseInternal(this.toStringAndClear(this.line)));
                if (this.nextLine) {
                    this.readyToReadData = true;
                }
                this.nextLine = true;
                continue;
            }
            if (c == '\r') continue;
            this.nextLine = false;
            this.line.put(b);
        }
    }

    public boolean doActualRead(ByteBuffer cb) {
        if (this.readyToReadData) {
            boolean done;
            if (this.chunked && (this.data == null || !this.data.hasRemaining()) && (done = this.readLine(cb))) {
                return true;
            }
            IOUtil.copyToHeapBuffer(cb, this.data);
        }
        this.setReadyToReadData(cb);
        return !this.chunked && this.data != null && !this.data.hasRemaining();
    }

    String toStringAndClear(ByteBuffer bb) {
        if (bb == null) {
            return "";
        }
        String result = bb.position() == 0 ? "" : StringUtil.bytesToString(bb.array(), 0, bb.position());
        bb.clear();
        return result;
    }

    boolean readLine(ByteBuffer cb) {
        boolean hasLine = false;
        while (cb.hasRemaining()) {
            byte b = cb.get();
            char c = (char)b;
            if (c == '\n') {
                hasLine = true;
                continue;
            }
            if (c == '\r') continue;
            this.line.put(b);
        }
        if (hasLine) {
            int dataSize;
            String lineStr = this.toStringAndClear(this.line).trim();
            int n = dataSize = lineStr.length() == 0 ? 0 : Integer.parseInt(lineStr, 16);
            if (dataSize == 0) {
                return true;
            }
            this.dataNullCheck(dataSize);
        }
        return false;
    }

    private void processLine(String currentLine) {
        if (this.contentType == null && currentLine.startsWith("content-type: ")) {
            this.contentType = currentLine.substring(currentLine.indexOf(32) + 1);
        } else if (this.data == null && currentLine.startsWith("content-length: ")) {
            this.data = ByteBuffer.allocate(Integer.parseInt(currentLine.substring(currentLine.indexOf(32) + 1)));
        } else if (!this.chunked && currentLine.startsWith("transfer-encoding: chunked")) {
            this.chunked = true;
        } else if (currentLine.startsWith("expect: 100")) {
            this.readHandler.sendResponse(new NoOpCommand(RES_100));
        }
    }
}

