/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.internal.cluster.impl;

import com.att.aft.dme2.hazelcast.instance.MemberImpl;
import com.att.aft.dme2.hazelcast.internal.cluster.impl.BindMessage;
import com.att.aft.dme2.hazelcast.internal.cluster.impl.ConfigCheck;
import com.att.aft.dme2.hazelcast.internal.cluster.impl.operations.FinalizeJoinOperation;
import com.att.aft.dme2.hazelcast.internal.cluster.impl.operations.HeartbeatOperation;
import com.att.aft.dme2.hazelcast.internal.cluster.impl.operations.MemberInfoUpdateOperation;
import com.att.aft.dme2.hazelcast.internal.serialization.DataSerializerHook;
import com.att.aft.dme2.hazelcast.nio.Address;
import com.att.aft.dme2.hazelcast.nio.serialization.DataSerializableFactory;
import com.att.aft.dme2.hazelcast.nio.serialization.IdentifiedDataSerializable;

public final class ClusterDataSerializerHook
implements DataSerializerHook {
    public static final int F_ID = 0;
    public static final int ADDRESS = 1;
    public static final int MEMBER = 2;
    public static final int HEARTBEAT = 3;
    public static final int CONFIG_CHECK = 4;
    public static final int BIND_MESSAGE = 5;
    public static final int MEMBER_INFO_UPDATE = 6;
    public static final int FINALIZE_JOIN = 7;
    private static final DataSerializableFactory FACTORY = new ClusterDataSerializerFactoryImpl();

    @Override
    public int getFactoryId() {
        return 0;
    }

    @Override
    public DataSerializableFactory createFactory() {
        return FACTORY;
    }

    public static class ClusterDataSerializerFactoryImpl
    implements DataSerializableFactory {
        @Override
        public IdentifiedDataSerializable create(int typeId) {
            switch (typeId) {
                case 1: {
                    return new Address();
                }
                case 2: {
                    return new MemberImpl();
                }
                case 3: {
                    return new HeartbeatOperation();
                }
                case 4: {
                    return new ConfigCheck();
                }
                case 5: {
                    return new BindMessage();
                }
                case 6: {
                    return new MemberInfoUpdateOperation();
                }
                case 7: {
                    return new FinalizeJoinOperation();
                }
            }
            return null;
        }
    }
}

