/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.internal.cluster.impl;

import com.att.aft.dme2.hazelcast.internal.cluster.MemberInfo;
import com.att.aft.dme2.hazelcast.internal.cluster.impl.ConfigCheck;
import com.att.aft.dme2.hazelcast.internal.cluster.impl.JoinMessage;
import com.att.aft.dme2.hazelcast.nio.Address;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.DataSerializable;
import com.att.aft.dme2.hazelcast.security.Credentials;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class JoinRequest
extends JoinMessage
implements DataSerializable {
    private Credentials credentials;
    private int tryCount;
    private Map<String, Object> attributes;

    public JoinRequest() {
    }

    public JoinRequest(byte packetVersion, int buildNumber, Address address, String uuid, boolean liteMember, ConfigCheck config, Credentials credentials, Map<String, Object> attributes) {
        super(packetVersion, buildNumber, address, uuid, liteMember, config);
        this.credentials = credentials;
        this.attributes = attributes;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public int getTryCount() {
        return this.tryCount;
    }

    public void setTryCount(int tryCount) {
        this.tryCount = tryCount;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public MemberInfo toMemberInfo() {
        return new MemberInfo(this.address, this.uuid, this.attributes, this.liteMember);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.credentials = (Credentials)in.readObject();
        if (this.credentials != null) {
            this.credentials.setEndpoint(this.getAddress().getHost());
        }
        this.tryCount = in.readInt();
        int size = in.readInt();
        this.attributes = new HashMap<String, Object>();
        for (int i = 0; i < size; ++i) {
            String key = in.readUTF();
            Object value = in.readObject();
            this.attributes.put(key, value);
        }
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeObject(this.credentials);
        out.writeInt(this.tryCount);
        out.writeInt(this.attributes.size());
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeObject(entry.getValue());
        }
    }

    @Override
    public String toString() {
        return "JoinRequest{packetVersion=" + this.packetVersion + ", buildNumber=" + this.buildNumber + ", address=" + this.address + ", uuid='" + this.uuid + "'" + ", liteMember=" + this.liteMember + ", credentials=" + this.credentials + ", memberCount=" + this.getMemberCount() + ", tryCount=" + this.tryCount + '}';
    }
}

