/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.internal.cluster.impl;

import com.att.aft.dme2.hazelcast.cluster.ClusterState;
import com.att.aft.dme2.hazelcast.cluster.Joiner;
import com.att.aft.dme2.hazelcast.instance.Node;
import com.att.aft.dme2.hazelcast.internal.cluster.impl.ClusterJoinManager;
import java.util.concurrent.atomic.AtomicBoolean;

final class SplitBrainHandler
implements Runnable {
    private final Node node;
    private final AtomicBoolean inProgress = new AtomicBoolean(false);

    public SplitBrainHandler(Node node) {
        this.node = node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.shouldRun()) {
            return;
        }
        if (this.inProgress.compareAndSet(false, true)) {
            try {
                this.searchForOtherClusters();
            }
            finally {
                this.inProgress.set(false);
            }
        }
    }

    private boolean shouldRun() {
        if (!this.node.joined()) {
            return false;
        }
        if (!this.node.isMaster()) {
            return false;
        }
        if (!this.node.isRunning()) {
            return false;
        }
        ClusterJoinManager clusterJoinManager = this.node.clusterService.getClusterJoinManager();
        if (clusterJoinManager.isJoinInProgress()) {
            return false;
        }
        ClusterState clusterState = this.node.clusterService.getClusterState();
        return clusterState == ClusterState.ACTIVE;
    }

    private void searchForOtherClusters() {
        Joiner joiner = this.node.getJoiner();
        if (joiner != null) {
            joiner.searchForOtherClusters();
        }
    }
}

