/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.internal.cluster.impl.operations;

import com.att.aft.dme2.hazelcast.instance.Node;
import com.att.aft.dme2.hazelcast.internal.cluster.impl.operations.AbstractClusterOperation;
import com.att.aft.dme2.hazelcast.internal.cluster.impl.operations.JoinOperation;
import com.att.aft.dme2.hazelcast.logging.ILogger;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.spi.impl.NodeEngineImpl;
import java.io.IOException;

public class BeforeJoinCheckFailureOperation
extends AbstractClusterOperation
implements JoinOperation {
    private String failReasonMsg;

    public BeforeJoinCheckFailureOperation() {
    }

    public BeforeJoinCheckFailureOperation(String failReasonMsg) {
        this.failReasonMsg = failReasonMsg;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.failReasonMsg);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.failReasonMsg = in.readUTF();
    }

    @Override
    public void run() {
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        Node node = nodeEngine.getNode();
        if (node.joined()) {
            throw new IllegalStateException("Node is already joined but received a termination message! Reason: " + this.failReasonMsg);
        }
        ILogger logger = nodeEngine.getLogger("com.att.aft.dme2.hazelcast.security");
        logger.severe("Node could not join cluster. Before join check failed node is going to shutdown now!");
        logger.severe("Reason of failure for node join : " + this.failReasonMsg);
        node.shutdown(true);
    }
}

