/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.internal.cluster.impl.operations;

import com.att.aft.dme2.hazelcast.instance.Node;
import com.att.aft.dme2.hazelcast.internal.cluster.impl.operations.AbstractClusterOperation;
import com.att.aft.dme2.hazelcast.internal.cluster.impl.operations.JoinOperation;
import com.att.aft.dme2.hazelcast.logging.ILogger;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.spi.impl.NodeEngineImpl;
import java.io.IOException;

public class ConfigMismatchOperation
extends AbstractClusterOperation
implements JoinOperation {
    private String msg;

    public ConfigMismatchOperation() {
    }

    public ConfigMismatchOperation(String msg) {
        this.msg = msg;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.msg);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.msg = in.readUTF();
    }

    @Override
    public void run() {
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        Node node = nodeEngine.getNode();
        ILogger logger = nodeEngine.getLogger("com.att.aft.dme2.hazelcast.cluster");
        logger.severe("Node could not join cluster. A Configuration mismatch was detected: " + this.msg + " Node is going to shutdown now!");
        node.shutdown(true);
    }
}

