/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.internal.cluster.impl.operations;

import com.att.aft.dme2.hazelcast.instance.MemberImpl;
import com.att.aft.dme2.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.att.aft.dme2.hazelcast.internal.cluster.impl.operations.AbstractClusterOperation;
import com.att.aft.dme2.hazelcast.internal.cluster.impl.operations.JoinOperation;
import com.att.aft.dme2.hazelcast.logging.ILogger;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;

public final class HeartbeatOperation
extends AbstractClusterOperation
implements JoinOperation,
IdentifiedDataSerializable {
    private long timestamp;

    public HeartbeatOperation() {
    }

    public HeartbeatOperation(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public void run() {
        ClusterServiceImpl service = (ClusterServiceImpl)this.getService();
        MemberImpl member = service.getMember(this.getCallerAddress());
        if (member == null) {
            ILogger logger = this.getLogger();
            if (logger.isFineEnabled()) {
                logger.fine("Heartbeat received from an unknown endpoint: " + this.getCallerAddress());
            }
            return;
        }
        service.getClusterHeartbeatManager().onHeartbeat(member, this.timestamp);
    }

    @Override
    public int getFactoryId() {
        return 0;
    }

    @Override
    public int getId() {
        return 3;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.timestamp);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.timestamp = in.readLong();
    }
}

