/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.internal.cluster.impl.operations;

import com.att.aft.dme2.hazelcast.cluster.ClusterState;
import com.att.aft.dme2.hazelcast.core.MemberLeftException;
import com.att.aft.dme2.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.att.aft.dme2.hazelcast.internal.cluster.impl.ClusterStateManager;
import com.att.aft.dme2.hazelcast.nio.Address;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.spi.AbstractOperation;
import com.att.aft.dme2.hazelcast.spi.ExceptionAction;
import com.att.aft.dme2.hazelcast.spi.exception.TargetNotMemberException;
import com.att.aft.dme2.hazelcast.spi.impl.AllowedDuringPassiveState;
import com.att.aft.dme2.hazelcast.transaction.TransactionException;
import com.att.aft.dme2.hazelcast.util.EmptyStatement;
import java.io.IOException;

public class LockClusterStateOperation
extends AbstractOperation
implements AllowedDuringPassiveState {
    private String stateName;
    private ClusterState newState;
    private Address initiator;
    private String txnId;
    private long leaseTime;
    private int partitionStateVersion;

    public LockClusterStateOperation() {
    }

    public LockClusterStateOperation(ClusterState newState, Address initiator, String txnId, long leaseTime, int partitionStateVersion) {
        this.newState = newState;
        this.initiator = initiator;
        this.txnId = txnId;
        this.leaseTime = leaseTime;
        this.partitionStateVersion = partitionStateVersion;
    }

    @Override
    public void beforeRun() throws Exception {
        if (this.newState == null) {
            throw new IllegalArgumentException("Unknown cluster state: " + this.stateName);
        }
    }

    @Override
    public void run() throws Exception {
        ClusterServiceImpl service = (ClusterServiceImpl)this.getService();
        ClusterStateManager clusterStateManager = service.getClusterStateManager();
        ClusterState state = clusterStateManager.getState();
        if (state == ClusterState.IN_TRANSITION) {
            this.getLogger().info("Extending cluster state lock. Initiator: " + this.initiator + ", lease-time: " + this.leaseTime);
        } else {
            this.getLogger().info("Locking cluster state. Initiator: " + this.initiator + ", lease-time: " + this.leaseTime);
        }
        clusterStateManager.lockClusterState(this.newState, this.initiator, this.txnId, this.leaseTime, this.partitionStateVersion);
    }

    @Override
    public void logError(Throwable e) {
        if (e instanceof TransactionException) {
            this.getLogger().severe(e.getMessage());
        } else {
            super.logError(e);
        }
    }

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        if (throwable instanceof MemberLeftException || throwable instanceof TargetNotMemberException) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        return super.onInvocationException(throwable);
    }

    @Override
    public String getServiceName() {
        return "hz:core:clusterService";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.newState.toString());
        this.initiator.writeData(out);
        out.writeUTF(this.txnId);
        out.writeLong(this.leaseTime);
        out.writeInt(this.partitionStateVersion);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.stateName = in.readUTF();
        try {
            this.newState = ClusterState.valueOf(this.stateName);
        }
        catch (IllegalArgumentException ignored) {
            EmptyStatement.ignore(ignored);
        }
        this.initiator = new Address();
        this.initiator.readData(in);
        this.txnId = in.readUTF();
        this.leaseTime = in.readLong();
        this.partitionStateVersion = in.readInt();
    }
}

