/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.internal.cluster.impl.operations;

import com.att.aft.dme2.hazelcast.cluster.Joiner;
import com.att.aft.dme2.hazelcast.cluster.impl.TcpIpJoiner;
import com.att.aft.dme2.hazelcast.instance.Node;
import com.att.aft.dme2.hazelcast.internal.cluster.impl.operations.JoinOperation;
import com.att.aft.dme2.hazelcast.logging.ILogger;
import com.att.aft.dme2.hazelcast.nio.Address;
import com.att.aft.dme2.hazelcast.spi.AbstractOperation;
import com.att.aft.dme2.hazelcast.spi.impl.NodeEngineImpl;

public class MasterClaimOperation
extends AbstractOperation
implements JoinOperation {
    private transient boolean approvedAsMaster;

    @Override
    public void run() {
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        Node node = nodeEngine.getNode();
        Joiner joiner = node.getJoiner();
        ILogger logger = node.getLogger(this.getClass().getName());
        if (joiner instanceof TcpIpJoiner) {
            TcpIpJoiner tcpIpJoiner = (TcpIpJoiner)joiner;
            Address endpoint = this.getCallerAddress();
            Address masterAddress = node.getMasterAddress();
            this.approvedAsMaster = !tcpIpJoiner.isClaimingMaster() && !node.isMaster() && (masterAddress == null || masterAddress.equals(endpoint));
        } else {
            this.approvedAsMaster = false;
            logger.warning("This node requires MulticastJoin strategy!");
        }
        if (logger.isFineEnabled()) {
            logger.fine("Sending '" + this.approvedAsMaster + "' for master claim of node: " + this.getCallerAddress());
        }
    }

    @Override
    public Object getResponse() {
        return this.approvedAsMaster;
    }
}

