/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.internal.cluster.impl.operations;

import com.att.aft.dme2.hazelcast.instance.MemberImpl;
import com.att.aft.dme2.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.att.aft.dme2.hazelcast.internal.cluster.impl.operations.AbstractClusterOperation;
import com.att.aft.dme2.hazelcast.internal.cluster.impl.operations.MemberRemoveOperation;
import com.att.aft.dme2.hazelcast.logging.ILogger;
import com.att.aft.dme2.hazelcast.nio.Address;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.spi.OperationService;
import com.att.aft.dme2.hazelcast.spi.impl.AllowedDuringPassiveState;
import java.io.IOException;

public class MasterConfirmationOperation
extends AbstractClusterOperation
implements AllowedDuringPassiveState {
    private long timestamp;

    public MasterConfirmationOperation() {
    }

    public MasterConfirmationOperation(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public void run() {
        Address endpoint = this.getCallerAddress();
        if (endpoint == null) {
            return;
        }
        ClusterServiceImpl clusterService = (ClusterServiceImpl)this.getService();
        ILogger logger = this.getLogger();
        MemberImpl member = clusterService.getMember(endpoint);
        if (member == null) {
            logger.warning("MasterConfirmation has been received from " + endpoint + ", but it is not a member of this cluster!");
            OperationService operationService = this.getNodeEngine().getOperationService();
            operationService.send(new MemberRemoveOperation(clusterService.getThisAddress()), endpoint);
        } else if (clusterService.isMaster()) {
            clusterService.getClusterHeartbeatManager().acceptMasterConfirmation(member, this.timestamp);
        } else {
            logger.warning(endpoint + " has sent MasterConfirmation, but this node is not master!");
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.timestamp);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.timestamp = in.readLong();
    }
}

