/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.internal.cluster.impl.operations;

import com.att.aft.dme2.hazelcast.cluster.MemberAttributeOperationType;
import com.att.aft.dme2.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.att.aft.dme2.hazelcast.internal.cluster.impl.operations.AbstractClusterOperation;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;

public class MemberAttributeChangedOperation
extends AbstractClusterOperation {
    private MemberAttributeOperationType operationType;
    private String key;
    private Object value;

    public MemberAttributeChangedOperation() {
    }

    public MemberAttributeChangedOperation(MemberAttributeOperationType operationType, String key, Object value) {
        this.operationType = operationType;
        this.key = key;
        this.value = value;
    }

    @Override
    public void run() throws Exception {
        ClusterServiceImpl cs = (ClusterServiceImpl)this.getService();
        cs.updateMemberAttribute(this.getCallerUuid(), this.operationType, this.key, this.value);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.key);
        out.writeByte(this.operationType.getId());
        if (this.operationType == MemberAttributeOperationType.PUT) {
            out.writeObject(this.value);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.key = in.readUTF();
        this.operationType = MemberAttributeOperationType.getValue(in.readByte());
        if (this.operationType == MemberAttributeOperationType.PUT) {
            this.value = in.readObject();
        }
    }
}

