/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.internal.cluster.impl.operations;

import com.att.aft.dme2.hazelcast.internal.cluster.impl.operations.JoinOperation;
import com.att.aft.dme2.hazelcast.logging.ILogger;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.spi.AbstractOperation;
import com.att.aft.dme2.hazelcast.spi.NodeEngine;
import com.att.aft.dme2.hazelcast.spi.Operation;
import com.att.aft.dme2.hazelcast.spi.OperationAccessor;
import com.att.aft.dme2.hazelcast.spi.OperationResponseHandler;
import com.att.aft.dme2.hazelcast.spi.UrgentSystemOperation;
import com.att.aft.dme2.hazelcast.util.Preconditions;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;

public class PostJoinOperation
extends AbstractOperation
implements UrgentSystemOperation,
JoinOperation {
    private Operation[] operations;

    public PostJoinOperation() {
    }

    public PostJoinOperation(Operation ... ops) {
        for (Operation op : ops) {
            Preconditions.checkNotNull(op, "op can't be null");
            Preconditions.checkNegative(op.getPartitionId(), "Post join operation can not have a partition-id!");
        }
        this.operations = ops;
    }

    @Override
    public void beforeRun() throws Exception {
        if (this.operations != null && this.operations.length > 0) {
            final NodeEngine nodeEngine = this.getNodeEngine();
            for (Operation op : this.operations) {
                op.setNodeEngine(nodeEngine);
                op.setOperationResponseHandler(new OperationResponseHandler(){

                    public void sendResponse(Operation op, Object obj) {
                        if (obj instanceof Throwable) {
                            Throwable t = (Throwable)obj;
                            ILogger logger = nodeEngine.getLogger(op.getClass());
                            logger.warning("Error while running post-join operation: " + t.getClass().getSimpleName() + ": " + t.getMessage());
                            if (logger.isFineEnabled()) {
                                logger.log(Level.FINE, "Error while running post-join operation: ", t);
                            }
                        }
                    }

                    @Override
                    public boolean isLocal() {
                        return true;
                    }
                });
                OperationAccessor.setCallerAddress(op, this.getCallerAddress());
                OperationAccessor.setConnection(op, this.getConnection());
                this.operations[i] = op;
            }
        }
    }

    @Override
    public void run() throws Exception {
        if (this.operations != null && this.operations.length > 0) {
            for (Operation op : this.operations) {
                op.beforeRun();
                op.run();
                op.afterRun();
            }
        }
    }

    @Override
    public void onExecutionFailure(Throwable e) {
        if (this.operations != null) {
            for (Operation op : this.operations) {
                this.onOperationFailure(op, e);
            }
        }
    }

    private void onOperationFailure(Operation op, Throwable e) {
        try {
            op.onExecutionFailure(e);
        }
        catch (Throwable t) {
            this.getLogger().warning("While calling operation.onFailure(). op: " + op, t);
        }
    }

    @Override
    public boolean validatesTarget() {
        return false;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        int len = this.operations != null ? this.operations.length : 0;
        out.writeInt(len);
        if (len > 0) {
            for (Operation op : this.operations) {
                out.writeObject(op);
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        int len = in.readInt();
        this.operations = new Operation[len];
        for (int i = 0; i < len; ++i) {
            this.operations[i] = (Operation)in.readObject();
        }
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", operations=").append(Arrays.toString(this.operations));
    }
}

