/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.internal.cluster.impl.operations;

import com.att.aft.dme2.hazelcast.core.MemberLeftException;
import com.att.aft.dme2.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.att.aft.dme2.hazelcast.internal.cluster.impl.ClusterStateManager;
import com.att.aft.dme2.hazelcast.nio.Address;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.spi.AbstractOperation;
import com.att.aft.dme2.hazelcast.spi.ExceptionAction;
import com.att.aft.dme2.hazelcast.spi.exception.TargetNotMemberException;
import com.att.aft.dme2.hazelcast.spi.impl.AllowedDuringPassiveState;
import java.io.IOException;

public class RollbackClusterStateOperation
extends AbstractOperation
implements AllowedDuringPassiveState {
    private Address initiator;
    private String txnId;
    private boolean response;

    public RollbackClusterStateOperation() {
    }

    public RollbackClusterStateOperation(Address initiator, String txnId) {
        this.initiator = initiator;
        this.txnId = txnId;
    }

    @Override
    public void run() throws Exception {
        ClusterServiceImpl service = (ClusterServiceImpl)this.getService();
        ClusterStateManager clusterStateManager = service.getClusterStateManager();
        this.getLogger().info("Rolling back cluster state! Initiator: " + this.initiator);
        this.response = clusterStateManager.rollbackClusterState(this.txnId);
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    public String getServiceName() {
        return "hz:core:clusterService";
    }

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        if (throwable instanceof MemberLeftException || throwable instanceof TargetNotMemberException) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        return super.onInvocationException(throwable);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        this.initiator.writeData(out);
        out.writeUTF(this.txnId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.initiator = new Address();
        this.initiator.readData(in);
        this.txnId = in.readUTF();
    }
}

