/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.internal.diagnostics;

import com.att.aft.dme2.hazelcast.internal.diagnostics.DiagnosticsLogWriter;
import com.att.aft.dme2.hazelcast.internal.diagnostics.DiagnosticsPlugin;
import com.att.aft.dme2.hazelcast.logging.ILogger;
import com.att.aft.dme2.hazelcast.spi.impl.NodeEngineImpl;
import com.att.aft.dme2.hazelcast.spi.properties.HazelcastProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ConfigPropertiesPlugin
extends DiagnosticsPlugin {
    private final HazelcastProperties properties;
    private final List<String> keyList = new ArrayList<String>();

    public ConfigPropertiesPlugin(NodeEngineImpl nodeEngine) {
        this(nodeEngine.getLogger(ConfigPropertiesPlugin.class), nodeEngine.getProperties());
    }

    public ConfigPropertiesPlugin(ILogger logger, HazelcastProperties properties) {
        super(logger);
        this.properties = properties;
    }

    @Override
    public void onStart() {
        this.logger.info("Plugin:active");
    }

    @Override
    public long getPeriodMillis() {
        return -1L;
    }

    @Override
    public void run(DiagnosticsLogWriter writer) {
        this.keyList.clear();
        this.keyList.addAll(this.properties.keySet());
        Collections.sort(this.keyList);
        writer.startSection("ConfigProperties");
        for (String key : this.keyList) {
            String value = this.properties.get(key);
            writer.writeKeyValueEntry(key, value);
        }
        writer.endSection();
    }
}

