/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.internal.diagnostics;

import com.att.aft.dme2.hazelcast.internal.diagnostics.Diagnostics;
import com.att.aft.dme2.hazelcast.internal.diagnostics.DiagnosticsLogWriter;
import com.att.aft.dme2.hazelcast.internal.diagnostics.DiagnosticsPlugin;
import com.att.aft.dme2.hazelcast.internal.diagnostics.MultiLineDiagnosticsLogWriter;
import com.att.aft.dme2.hazelcast.internal.diagnostics.SingleLineDiagnosticsLogWriter;
import com.att.aft.dme2.hazelcast.logging.ILogger;
import com.att.aft.dme2.hazelcast.nio.IOUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

final class DiagnosticsLogFile {
    private static final int ONE_MB = 0x100000;
    private static final int INITIAL_CHAR_BUFF_SIZE = 4096;
    volatile File file;
    private final Diagnostics diagnostics;
    private final ILogger logger;
    private final String fileName;
    private char[] charBuff = new char[4096];
    private int index;
    private BufferedWriter bufferedWriter;
    private int maxRollingFileCount;
    private int maxRollingFileSizeBytes;
    private final DiagnosticsLogWriter logWriter;
    private long fileLength;

    DiagnosticsLogFile(Diagnostics diagnostics) {
        this.diagnostics = diagnostics;
        this.logWriter = diagnostics.singleLine ? new SingleLineDiagnosticsLogWriter() : new MultiLineDiagnosticsLogWriter();
        this.logger = diagnostics.logger;
        this.fileName = diagnostics.fileName + "-%03d.log";
        this.maxRollingFileCount = diagnostics.properties.getInteger(Diagnostics.MAX_ROLLED_FILE_COUNT);
        this.maxRollingFileSizeBytes = Math.round(1048576.0f * diagnostics.properties.getFloat(Diagnostics.MAX_ROLLED_FILE_SIZE_MB));
        this.logger.finest("maxRollingFileSizeBytes:" + this.maxRollingFileSizeBytes + " maxRollingFileCount:" + this.maxRollingFileCount);
    }

    public void write(DiagnosticsPlugin plugin) {
        try {
            if (this.file == null) {
                this.file = new File(this.diagnostics.directory, String.format(this.fileName, this.index));
                this.bufferedWriter = this.newWriter();
                this.renderStaticPlugins();
            }
            this.renderPlugin(plugin);
            this.bufferedWriter.flush();
            if (this.fileLength >= (long)this.maxRollingFileSizeBytes) {
                this.rollover();
            }
        }
        catch (IOException e) {
            this.logger.warning("Failed to write to file:" + this.file.getAbsolutePath(), e);
            this.file = null;
            IOUtil.closeResource(this.bufferedWriter);
            this.bufferedWriter = null;
        }
        catch (RuntimeException e) {
            this.logger.warning("Failed to write file: " + this.file, e);
        }
    }

    private void renderStaticPlugins() throws IOException {
        for (DiagnosticsPlugin plugin : this.diagnostics.staticTasks.get()) {
            this.renderPlugin(plugin);
        }
    }

    private void renderPlugin(DiagnosticsPlugin plugin) throws IOException {
        int desiredLength;
        this.logWriter.clean();
        plugin.run(this.logWriter);
        int actualSize = this.logWriter.length();
        for (desiredLength = this.charBuff.length; desiredLength < actualSize; desiredLength *= 2) {
        }
        if (desiredLength != this.charBuff.length) {
            this.charBuff = new char[desiredLength];
        }
        this.logWriter.copyInto(this.charBuff);
        this.bufferedWriter.write(this.charBuff, 0, actualSize);
        this.fileLength += (long)actualSize;
    }

    private BufferedWriter newWriter() throws FileNotFoundException {
        FileOutputStream fos = new FileOutputStream(this.file, true);
        CharsetEncoder encoder = Charset.forName("UTF-8").newEncoder();
        return new BufferedWriter(new OutputStreamWriter((OutputStream)fos, encoder));
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    private void rollover() {
        IOUtil.closeResource(this.bufferedWriter);
        this.bufferedWriter = null;
        this.file = null;
        this.fileLength = 0L;
        ++this.index;
        File file = new File(String.format(this.fileName, this.index - this.maxRollingFileCount));
        file.delete();
    }
}

