/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.internal.diagnostics;

import com.att.aft.dme2.hazelcast.internal.diagnostics.DiagnosticsLogWriter;
import com.att.aft.dme2.hazelcast.internal.diagnostics.DiagnosticsPlugin;
import com.att.aft.dme2.hazelcast.nio.ConnectionManager;
import com.att.aft.dme2.hazelcast.nio.OutboundFrame;
import com.att.aft.dme2.hazelcast.nio.Packet;
import com.att.aft.dme2.hazelcast.nio.tcp.TcpIpConnection;
import com.att.aft.dme2.hazelcast.nio.tcp.TcpIpConnectionManager;
import com.att.aft.dme2.hazelcast.nio.tcp.nonblocking.NonBlockingSocketWriter;
import com.att.aft.dme2.hazelcast.nio.tcp.spinning.SpinningSocketWriter;
import com.att.aft.dme2.hazelcast.spi.impl.NodeEngineImpl;
import com.att.aft.dme2.hazelcast.spi.impl.operationservice.impl.operations.Backup;
import com.att.aft.dme2.hazelcast.spi.properties.HazelcastProperties;
import com.att.aft.dme2.hazelcast.spi.properties.HazelcastProperty;
import com.att.aft.dme2.hazelcast.spi.serialization.SerializationService;
import com.att.aft.dme2.hazelcast.util.ItemCounter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class OverloadedConnectionsPlugin
extends DiagnosticsPlugin {
    public static final HazelcastProperty PERIOD_SECONDS = new HazelcastProperty("hazelcast.diagnostics.overloaded.connections.period.seconds", 0, TimeUnit.SECONDS);
    public static final HazelcastProperty THRESHOLD = new HazelcastProperty("hazelcast.diagnostics.overloaded.connections.threshold", 10000);
    public static final HazelcastProperty SAMPLES = new HazelcastProperty("hazelcast.diagnostics.overloaded.connections.samples", 1000);
    private static final Queue<OutboundFrame> EMPTY_QUEUE = new LinkedList<OutboundFrame>();
    private final SerializationService serializationService;
    private final ItemCounter<String> occurrenceMap = new ItemCounter();
    private final ArrayList<OutboundFrame> packets = new ArrayList();
    private final Random random = new Random();
    private final NumberFormat defaultFormat = NumberFormat.getPercentInstance();
    private final NodeEngineImpl nodeEngine;
    private final long periodMillis;
    private final int threshold;
    private final int samples;

    public OverloadedConnectionsPlugin(NodeEngineImpl nodeEngine) {
        super(nodeEngine.getLogger(OverloadedConnectionsPlugin.class));
        this.nodeEngine = nodeEngine;
        this.serializationService = nodeEngine.getSerializationService();
        this.defaultFormat.setMinimumFractionDigits(3);
        HazelcastProperties props = nodeEngine.getProperties();
        this.periodMillis = props.getMillis(PERIOD_SECONDS);
        this.threshold = props.getInteger(THRESHOLD);
        this.samples = props.getInteger(SAMPLES);
    }

    @Override
    public long getPeriodMillis() {
        return this.periodMillis;
    }

    @Override
    public void onStart() {
        this.logger.info("Plugin:active, period-millis:" + this.periodMillis + " threshold:" + this.threshold + " samples:" + this.samples);
    }

    @Override
    public void run(DiagnosticsLogWriter writer) {
        writer.startSection("OverloadedConnections");
        Set<TcpIpConnection> connections = this.getTcpIpConnections();
        for (TcpIpConnection connection : connections) {
            this.clear();
            this.scan(writer, connection, false);
            this.clear();
            this.scan(writer, connection, true);
        }
        writer.endSection();
    }

    private Set<TcpIpConnection> getTcpIpConnections() {
        ConnectionManager connectionManager = this.nodeEngine.getNode().getConnectionManager();
        if (connectionManager instanceof TcpIpConnectionManager) {
            return ((TcpIpConnectionManager)connectionManager).getActiveConnections();
        }
        return Collections.emptySet();
    }

    private void scan(DiagnosticsLogWriter writer, TcpIpConnection connection, boolean priority) {
        Queue<OutboundFrame> q = this.getOutboundQueue(connection, priority);
        int sampleCount = this.sample(q);
        if (sampleCount < 0) {
            return;
        }
        this.render(writer, connection, priority, sampleCount);
    }

    private Queue<OutboundFrame> getOutboundQueue(TcpIpConnection connection, boolean priority) {
        if (connection.getSocketWriter() instanceof NonBlockingSocketWriter) {
            NonBlockingSocketWriter writer = (NonBlockingSocketWriter)connection.getSocketWriter();
            return priority ? writer.urgentWriteQueue : writer.writeQueue;
        }
        if (connection.getSocketWriter() instanceof SpinningSocketWriter) {
            SpinningSocketWriter writer = (SpinningSocketWriter)connection.getSocketWriter();
            return priority ? writer.urgentWriteQueue : writer.writeQueue;
        }
        return EMPTY_QUEUE;
    }

    private void render(DiagnosticsLogWriter writer, TcpIpConnection connection, boolean priority, int sampleCount) {
        writer.startSection(connection.toString());
        writer.writeKeyValueEntry(priority ? "urgentPacketCount" : "packetCount", this.packets.size());
        writer.writeKeyValueEntry("sampleCount", sampleCount);
        this.renderSamples(writer, sampleCount);
        writer.endSection();
    }

    private void renderSamples(DiagnosticsLogWriter writer, int sampleCount) {
        writer.startSection("samples");
        for (String key : this.occurrenceMap.keySet()) {
            long value = this.occurrenceMap.get(key);
            if (value == 0L) continue;
            double percentage = 1.0 * (double)value / (double)sampleCount;
            writer.writeEntry(key + " sampleCount=" + value + " " + this.defaultFormat.format(percentage));
        }
        writer.endSection();
    }

    private void clear() {
        this.occurrenceMap.reset();
        this.packets.clear();
    }

    private int sample(Queue<OutboundFrame> q) {
        for (OutboundFrame frame : q) {
            this.packets.add(frame);
        }
        if (this.packets.size() < this.threshold) {
            return -1;
        }
        int sampleCount = Math.min(this.samples, this.packets.size());
        int actualSampleCount = 0;
        for (int k = 0; k < sampleCount; ++k) {
            OutboundFrame packet = this.packets.get(this.random.nextInt(this.packets.size()));
            String key = this.toKey(packet);
            if (key == null) continue;
            ++actualSampleCount;
            this.occurrenceMap.add(key, 1L);
        }
        return actualSampleCount;
    }

    String toKey(OutboundFrame packet) {
        if (packet instanceof Packet) {
            try {
                Object result = this.serializationService.toObject(packet);
                if (result == null) {
                    return "null";
                }
                if (result instanceof Backup) {
                    Backup backup = (Backup)result;
                    return Backup.class.getName() + "#" + backup.getBackupOp().getClass().getName();
                }
                return result.getClass().getName();
            }
            catch (Exception ignore) {
                this.logger.severe(ignore);
                return null;
            }
        }
        return packet.getClass().getName();
    }
}

