/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.internal.diagnostics;

import com.att.aft.dme2.hazelcast.internal.diagnostics.DiagnosticsLogWriter;
import com.att.aft.dme2.hazelcast.internal.diagnostics.DiagnosticsPlugin;
import com.att.aft.dme2.hazelcast.spi.impl.NodeEngineImpl;
import com.att.aft.dme2.hazelcast.spi.impl.operationservice.InternalOperationService;
import com.att.aft.dme2.hazelcast.spi.impl.operationservice.impl.Invocation;
import com.att.aft.dme2.hazelcast.spi.impl.operationservice.impl.InvocationRegistry;
import com.att.aft.dme2.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.att.aft.dme2.hazelcast.spi.properties.HazelcastProperties;
import com.att.aft.dme2.hazelcast.spi.properties.HazelcastProperty;
import com.att.aft.dme2.hazelcast.util.ItemCounter;
import java.util.concurrent.TimeUnit;

public final class PendingInvocationsPlugin
extends DiagnosticsPlugin {
    public static final HazelcastProperty PERIOD_SECONDS = new HazelcastProperty("hazelcast.diagnostics.pending.invocations.period.seconds", 0, TimeUnit.SECONDS);
    public static final HazelcastProperty THRESHOLD = new HazelcastProperty("hazelcast.diagnostics.pending.invocations.threshold", 1);
    private final InvocationRegistry invocationRegistry;
    private final ItemCounter<Class> occurrenceMap = new ItemCounter();
    private final long periodMillis;
    private final int threshold;

    public PendingInvocationsPlugin(NodeEngineImpl nodeEngine) {
        super(nodeEngine.getLogger(PendingInvocationsPlugin.class));
        InternalOperationService operationService = nodeEngine.getOperationService();
        this.invocationRegistry = ((OperationServiceImpl)operationService).getInvocationRegistry();
        HazelcastProperties props = nodeEngine.getProperties();
        this.periodMillis = props.getMillis(PERIOD_SECONDS);
        this.threshold = props.getInteger(THRESHOLD);
    }

    @Override
    public long getPeriodMillis() {
        return this.periodMillis;
    }

    @Override
    public void onStart() {
        this.logger.info("Plugin:active: period-millis:" + this.periodMillis + " threshold:" + this.threshold);
    }

    @Override
    public void run(DiagnosticsLogWriter writer) {
        this.clean();
        this.scan();
        this.render(writer);
    }

    private void clean() {
        this.occurrenceMap.reset();
    }

    private void scan() {
        for (Invocation invocation : this.invocationRegistry) {
            this.occurrenceMap.add(invocation.op.getClass(), 1L);
        }
    }

    private void render(DiagnosticsLogWriter writer) {
        writer.startSection("PendingInvocations");
        writer.writeKeyValueEntry("count", this.invocationRegistry.size());
        this.renderInvocations(writer);
        writer.endSection();
    }

    private void renderInvocations(DiagnosticsLogWriter writer) {
        writer.startSection("invocations");
        for (Class op : this.occurrenceMap.keySet()) {
            long count = this.occurrenceMap.get(op);
            if (count < (long)this.threshold) continue;
            writer.writeKeyValueEntry(op.getName(), count);
        }
        writer.endSection();
    }
}

