/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.internal.diagnostics;

import com.att.aft.dme2.hazelcast.internal.diagnostics.DiagnosticsLogWriter;
import com.att.aft.dme2.hazelcast.util.StringUtil;

class SingleLineDiagnosticsLogWriter
extends DiagnosticsLogWriter {
    private boolean firstEntry = true;

    SingleLineDiagnosticsLogWriter() {
    }

    @Override
    public void startSection(String name) {
        if (this.sectionLevel == -1) {
            this.appendDateTime();
            this.sb.append(' ');
        }
        this.appendComma();
        this.sb.append(name).append('[');
        this.firstEntry = true;
        ++this.sectionLevel;
    }

    @Override
    public void endSection() {
        this.sb.append(']');
        --this.sectionLevel;
        if (this.sectionLevel == -1) {
            this.sb.append(StringUtil.LINE_SEPARATOR);
        }
    }

    @Override
    public void writeEntry(String s) {
        this.appendComma();
        this.sb.append(s);
    }

    private void appendComma() {
        if (this.firstEntry) {
            this.firstEntry = false;
        } else {
            this.sb.append(',');
        }
    }

    @Override
    public void writeKeyValueEntry(String key, String value) {
        this.appendComma();
        this.sb.append(key).append('=').append(value);
    }

    @Override
    public void writeKeyValueEntry(String key, double value) {
        this.appendComma();
        this.sb.append(key).append('=').append(value);
    }

    @Override
    public void writeKeyValueEntry(String key, long value) {
        this.appendComma();
        this.sb.append(key).append('=').append(value);
    }

    @Override
    public void writeKeyValueEntry(String key, boolean value) {
        this.appendComma();
        this.sb.append(key).append('=').append(value);
    }

    @Override
    protected void clean() {
        this.firstEntry = true;
        super.clean();
    }
}

