/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.internal.diagnostics;

import com.att.aft.dme2.hazelcast.core.HazelcastInstance;
import com.att.aft.dme2.hazelcast.core.LifecycleEvent;
import com.att.aft.dme2.hazelcast.core.LifecycleListener;
import com.att.aft.dme2.hazelcast.core.Member;
import com.att.aft.dme2.hazelcast.core.MembershipAdapter;
import com.att.aft.dme2.hazelcast.core.MembershipEvent;
import com.att.aft.dme2.hazelcast.core.MigrationEvent;
import com.att.aft.dme2.hazelcast.core.MigrationListener;
import com.att.aft.dme2.hazelcast.internal.diagnostics.DiagnosticsLogWriter;
import com.att.aft.dme2.hazelcast.internal.diagnostics.DiagnosticsPlugin;
import com.att.aft.dme2.hazelcast.logging.ILogger;
import com.att.aft.dme2.hazelcast.nio.Address;
import com.att.aft.dme2.hazelcast.nio.Connection;
import com.att.aft.dme2.hazelcast.nio.ConnectionListenable;
import com.att.aft.dme2.hazelcast.nio.ConnectionListener;
import com.att.aft.dme2.hazelcast.spi.impl.NodeEngineImpl;
import com.att.aft.dme2.hazelcast.spi.properties.HazelcastProperties;
import com.att.aft.dme2.hazelcast.spi.properties.HazelcastProperty;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;

public class SystemLogPlugin
extends DiagnosticsPlugin {
    public static final HazelcastProperty ENABLED = new HazelcastProperty("hazelcast.diagnostics.systemlog.enabled", "true");
    public static final HazelcastProperty LOG_PARTITIONS = new HazelcastProperty("hazelcast.diagnostics.systemlog.partitions", "false");
    private static final long PERIOD_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    private final Queue<Object> logQueue = new ConcurrentLinkedQueue<Object>();
    private final ConnectionListenable connectionObservable;
    private final HazelcastInstance hazelcastInstance;
    private final Address thisAddress;
    private final boolean logPartitions;
    private final boolean enabled;

    public SystemLogPlugin(NodeEngineImpl nodeEngine) {
        this(nodeEngine.getProperties(), nodeEngine.getNode().connectionManager, nodeEngine.getHazelcastInstance(), nodeEngine.getLogger(SystemLogPlugin.class));
    }

    public SystemLogPlugin(HazelcastProperties properties, ConnectionListenable connectionObservable, HazelcastInstance hazelcastInstance, ILogger logger) {
        super(logger);
        this.connectionObservable = connectionObservable;
        this.hazelcastInstance = hazelcastInstance;
        this.thisAddress = this.getThisAddress(hazelcastInstance);
        this.logPartitions = properties.getBoolean(LOG_PARTITIONS);
        this.enabled = properties.getBoolean(ENABLED);
    }

    private Address getThisAddress(HazelcastInstance hazelcastInstance) {
        try {
            return hazelcastInstance.getCluster().getLocalMember().getAddress();
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    @Override
    public long getPeriodMillis() {
        if (!this.enabled) {
            return 0L;
        }
        return PERIOD_MILLIS;
    }

    @Override
    public void onStart() {
        this.logger.info("Plugin:active: logPartitions:" + this.logPartitions);
        this.connectionObservable.addConnectionListener(new ConnectionListenerImpl());
        this.hazelcastInstance.getCluster().addMembershipListener(new MembershipListenerImpl());
        if (this.logPartitions) {
            this.hazelcastInstance.getPartitionService().addMigrationListener(new MigrationListenerImpl());
        }
        this.hazelcastInstance.getLifecycleService().addLifecycleListener(new LifecycleListenerImpl());
    }

    @Override
    public void run(DiagnosticsLogWriter writer) {
        Object item;
        while ((item = this.logQueue.poll()) != null) {
            if (item instanceof LifecycleEvent) {
                this.render(writer, (LifecycleEvent)item);
                continue;
            }
            if (item instanceof MembershipEvent) {
                this.render(writer, (MembershipEvent)item);
                continue;
            }
            if (item instanceof MigrationEvent) {
                this.render(writer, (MigrationEvent)item);
                continue;
            }
            if (!(item instanceof ConnectionEvent)) continue;
            ConnectionEvent event = (ConnectionEvent)item;
            this.render(writer, event);
        }
        return;
    }

    private void render(DiagnosticsLogWriter writer, LifecycleEvent event) {
        writer.startSection("Lifecycle");
        writer.writeEntry(event.getState().name());
        writer.endSection();
    }

    private void render(DiagnosticsLogWriter writer, MembershipEvent event) {
        switch (event.getEventType()) {
            case 1: {
                writer.startSection("MemberAdded");
                break;
            }
            case 2: {
                writer.startSection("MemberRemoved");
                break;
            }
            default: {
                return;
            }
        }
        writer.writeKeyValueEntry("member", event.getMember().getAddress().toString());
        writer.startSection("Members");
        Set<Member> members = event.getMembers();
        if (members != null) {
            boolean first = true;
            for (Member member : members) {
                if (member.getAddress().equals(this.thisAddress)) {
                    if (first) {
                        writer.writeEntry(member.getAddress().toString() + ":this:master");
                    } else {
                        writer.writeEntry(member.getAddress().toString() + ":this");
                    }
                } else if (first) {
                    writer.writeEntry(member.getAddress().toString() + ":master");
                } else {
                    writer.writeEntry(member.getAddress().toString());
                }
                first = false;
            }
        }
        writer.endSection();
        writer.endSection();
    }

    private void render(DiagnosticsLogWriter writer, MigrationEvent event) {
        switch (event.getStatus()) {
            case STARTED: {
                writer.startSection("MigrationStarted");
                break;
            }
            case COMPLETED: {
                writer.startSection("MigrationCompleted");
                break;
            }
            case FAILED: {
                writer.startSection("MigrationFailed");
                break;
            }
            default: {
                return;
            }
        }
        Member oldOwner = event.getOldOwner();
        writer.writeKeyValueEntry("oldOwner", oldOwner == null ? "null" : oldOwner.getAddress().toString());
        writer.writeKeyValueEntry("newOwner", event.getNewOwner().getAddress().toString());
        writer.writeKeyValueEntry("partitionId", event.getPartitionId());
        writer.endSection();
    }

    private void render(DiagnosticsLogWriter writer, ConnectionEvent event) {
        if (event.added) {
            writer.startSection("ConnectionAdded");
        } else {
            writer.startSection("ConnectionRemoved");
        }
        Connection connection = event.connection;
        writer.writeEntry(connection.toString());
        writer.writeKeyValueEntry("type", connection.getType().name());
        writer.writeKeyValueEntry("isAlive", connection.isAlive());
        if (!event.added) {
            String closeReason = connection.getCloseReason();
            Throwable closeCause = connection.getCloseCause();
            if (closeReason == null && closeCause != null) {
                closeReason = closeCause.getMessage();
            }
            writer.writeKeyValueEntry("closeReason", closeReason == null ? "Unknown" : closeReason);
            if (closeCause != null) {
                writer.startSection("CloseCause");
                String s = closeCause.getClass().getName();
                String message = closeCause.getMessage();
                writer.writeEntry(message != null ? s + ": " + message : s);
                for (StackTraceElement element : closeCause.getStackTrace()) {
                    writer.writeEntry(element.toString());
                }
                writer.endSection();
            }
        }
        writer.endSection();
    }

    private class MigrationListenerImpl
    implements MigrationListener {
        private MigrationListenerImpl() {
        }

        @Override
        public void migrationStarted(MigrationEvent event) {
            SystemLogPlugin.this.logQueue.add(event);
        }

        @Override
        public void migrationCompleted(MigrationEvent event) {
            SystemLogPlugin.this.logQueue.add(event);
        }

        @Override
        public void migrationFailed(MigrationEvent event) {
            SystemLogPlugin.this.logQueue.add(event);
        }
    }

    private class MembershipListenerImpl
    extends MembershipAdapter {
        private MembershipListenerImpl() {
        }

        @Override
        public void memberAdded(MembershipEvent event) {
            SystemLogPlugin.this.logQueue.add(event);
        }

        @Override
        public void memberRemoved(MembershipEvent event) {
            SystemLogPlugin.this.logQueue.add(event);
        }
    }

    private class ConnectionListenerImpl
    implements ConnectionListener {
        private ConnectionListenerImpl() {
        }

        @Override
        public void connectionAdded(Connection connection) {
            SystemLogPlugin.this.logQueue.add(new ConnectionEvent(true, connection));
        }

        @Override
        public void connectionRemoved(Connection connection) {
            SystemLogPlugin.this.logQueue.add(new ConnectionEvent(false, connection));
        }
    }

    private static final class ConnectionEvent {
        final boolean added;
        final Connection connection;

        private ConnectionEvent(boolean added, Connection connection) {
            this.added = added;
            this.connection = connection;
        }
    }

    private class LifecycleListenerImpl
    implements LifecycleListener {
        private LifecycleListenerImpl() {
        }

        @Override
        public void stateChanged(LifecycleEvent event) {
            SystemLogPlugin.this.logQueue.add(event);
        }
    }
}

