/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.internal.eviction.impl.evaluator;

import com.att.aft.dme2.hazelcast.internal.eviction.Evictable;
import com.att.aft.dme2.hazelcast.internal.eviction.EvictionCandidate;
import com.att.aft.dme2.hazelcast.internal.eviction.EvictionPolicyComparator;
import com.att.aft.dme2.hazelcast.internal.eviction.EvictionPolicyEvaluator;
import com.att.aft.dme2.hazelcast.internal.eviction.Expirable;
import com.att.aft.dme2.hazelcast.util.Clock;
import java.util.Collections;
import java.util.Set;

public class DefaultEvictionPolicyEvaluator<A, E extends Evictable>
implements EvictionPolicyEvaluator<A, E> {
    private final EvictionPolicyComparator evictionPolicyComparator;

    public DefaultEvictionPolicyEvaluator(EvictionPolicyComparator evictionPolicyComparator) {
        this.evictionPolicyComparator = evictionPolicyComparator;
    }

    @Override
    public EvictionPolicyComparator getEvictionPolicyComparator() {
        return this.evictionPolicyComparator;
    }

    @Override
    public <C extends EvictionCandidate<A, E>> Iterable<C> evaluate(Iterable<C> evictionCandidates) {
        EvictionCandidate selectedEvictionCandidate = null;
        long now = Clock.currentTimeMillis();
        for (EvictionCandidate currentEvictionCandidate : evictionCandidates) {
            if (selectedEvictionCandidate == null) {
                selectedEvictionCandidate = currentEvictionCandidate;
                continue;
            }
            Object evictable = currentEvictionCandidate.getEvictable();
            if (this.isExpired(now, (Evictable)evictable)) {
                return this.returnEvictionCandidate(currentEvictionCandidate);
            }
            int comparisonResult = this.evictionPolicyComparator.compare(selectedEvictionCandidate, currentEvictionCandidate);
            if (comparisonResult != 1) continue;
            selectedEvictionCandidate = currentEvictionCandidate;
        }
        return this.returnEvictionCandidate(selectedEvictionCandidate);
    }

    private <C extends EvictionCandidate<A, E>> Iterable<C> returnEvictionCandidate(C evictionCandidate) {
        if (evictionCandidate == null) {
            return null;
        }
        return evictionCandidate instanceof Iterable ? (Set<C>)((Object)evictionCandidate) : Collections.singleton(evictionCandidate);
    }

    private boolean isExpired(long now, Evictable evictable) {
        boolean expired = false;
        if (evictable instanceof Expirable) {
            Expirable expirable = (Expirable)((Object)evictable);
            expired = expirable.isExpiredAt(now);
        }
        return expired;
    }
}

