/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.internal.jmx;

import com.att.aft.dme2.hazelcast.core.HazelcastInstance;
import com.att.aft.dme2.hazelcast.instance.Node;
import com.att.aft.dme2.hazelcast.internal.jmx.HazelcastMBean;
import com.att.aft.dme2.hazelcast.internal.jmx.ManagedAnnotation;
import com.att.aft.dme2.hazelcast.internal.jmx.ManagedDescription;
import com.att.aft.dme2.hazelcast.internal.jmx.ManagementService;
import com.att.aft.dme2.hazelcast.nio.Address;
import java.util.Hashtable;

@ManagedDescription(value="HazelcastInstance.Node")
public class NodeMBean
extends HazelcastMBean<Node> {
    private static final int INITIAL_CAPACITY = 3;

    public NodeMBean(HazelcastInstance hazelcastInstance, Node node, ManagementService service) {
        super(node, service);
        Hashtable<String, String> properties = new Hashtable<String, String>(3);
        properties.put("type", ManagementService.quote("HazelcastInstance.Node"));
        properties.put("name", ManagementService.quote("node" + node.address));
        properties.put("instance", ManagementService.quote(hazelcastInstance.getName()));
        this.setObjectName(properties);
    }

    @ManagedAnnotation(value="address")
    @ManagedDescription(value="Address of the node")
    public String getName() {
        return ((Node)this.managedObject).address.toString();
    }

    @ManagedAnnotation(value="masterAddress")
    @ManagedDescription(value="The master address of the cluster")
    public String getMasterAddress() {
        Address a = ((Node)this.managedObject).getMasterAddress();
        return a == null ? null : a.toString();
    }
}

