/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.internal.management.dto;

import com.att.aft.dme2.hazelcast.com.eclipsesource.json.JsonObject;
import com.att.aft.dme2.hazelcast.instance.HazelcastInstanceImpl;
import com.att.aft.dme2.hazelcast.internal.management.JsonSerializable;
import com.att.aft.dme2.hazelcast.internal.partition.InternalPartitionService;
import com.att.aft.dme2.hazelcast.nio.Address;
import com.att.aft.dme2.hazelcast.util.JsonUtil;

public class PartitionServiceBeanDTO
implements JsonSerializable {
    private int partitionCount;
    private int activePartitionCount;

    public PartitionServiceBeanDTO() {
    }

    public PartitionServiceBeanDTO(InternalPartitionService partitionService, HazelcastInstanceImpl hazelcastInstance) {
        Address address = hazelcastInstance.getCluster().getLocalMember().getAddress();
        this.partitionCount = partitionService.getPartitionCount();
        this.activePartitionCount = partitionService.getMemberPartitions(address).size();
    }

    public int getPartitionCount() {
        return this.partitionCount;
    }

    public void setPartitionCount(int partitionCount) {
        this.partitionCount = partitionCount;
    }

    public int getActivePartitionCount() {
        return this.activePartitionCount;
    }

    public void setActivePartitionCount(int activePartitionCount) {
        this.activePartitionCount = activePartitionCount;
    }

    @Override
    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        root.add("partitionCount", this.partitionCount);
        root.add("activePartitionCount", this.activePartitionCount);
        return root;
    }

    @Override
    public void fromJson(JsonObject json) {
        this.partitionCount = JsonUtil.getInt(json, "partitionCount", -1);
        this.activePartitionCount = JsonUtil.getInt(json, "activePartitionCount", -1);
    }
}

