/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.internal.management.request;

import com.att.aft.dme2.hazelcast.cluster.ClusterState;
import com.att.aft.dme2.hazelcast.com.eclipsesource.json.JsonObject;
import com.att.aft.dme2.hazelcast.core.Cluster;
import com.att.aft.dme2.hazelcast.internal.management.ManagementCenterService;
import com.att.aft.dme2.hazelcast.internal.management.request.AsyncConsoleRequest;
import com.att.aft.dme2.hazelcast.logging.ILogger;
import com.att.aft.dme2.hazelcast.util.JsonUtil;
import java.io.IOException;

public class ChangeClusterStateRequest
implements AsyncConsoleRequest {
    private static final String FAILURE = "FAILURE: ";
    private String state;

    public ChangeClusterStateRequest() {
    }

    public ChangeClusterStateRequest(String state) {
        this.state = state;
    }

    @Override
    public int getType() {
        return 35;
    }

    @Override
    public Object readResponse(JsonObject in) throws IOException {
        return JsonUtil.getString(in, "result", "FAILURE");
    }

    @Override
    public void writeResponse(ManagementCenterService mcs, JsonObject out) throws Exception {
        String resultString = "SUCCESS";
        try {
            Cluster cluster = mcs.getHazelcastInstance().getCluster();
            cluster.changeClusterState(ChangeClusterStateRequest.getClusterState(this.state));
        }
        catch (Exception e) {
            ILogger logger = mcs.getHazelcastInstance().node.nodeEngine.getLogger(this.getClass());
            logger.warning("Cluster state can not be changed: ", e);
            resultString = FAILURE + e.getMessage();
        }
        JsonObject result = new JsonObject().add("result", resultString);
        out.add("result", result);
    }

    private static ClusterState getClusterState(String state) {
        return ClusterState.valueOf(state);
    }

    @Override
    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        root.add("state", this.state);
        return root;
    }

    @Override
    public void fromJson(JsonObject json) {
        this.state = JsonUtil.getString(json, "state");
    }
}

