/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.internal.management.request;

import com.att.aft.dme2.hazelcast.com.eclipsesource.json.JsonObject;
import com.att.aft.dme2.hazelcast.internal.management.ConsoleCommandHandler;
import com.att.aft.dme2.hazelcast.internal.management.ManagementCenterService;
import com.att.aft.dme2.hazelcast.internal.management.request.ConsoleRequest;
import com.att.aft.dme2.hazelcast.util.JsonUtil;

public class ConsoleCommandRequest
implements ConsoleRequest {
    private String command;

    public ConsoleCommandRequest() {
    }

    public ConsoleCommandRequest(String command) {
        this.command = command;
    }

    @Override
    public int getType() {
        return 5;
    }

    @Override
    public void writeResponse(ManagementCenterService mcs, JsonObject root) throws Exception {
        ConsoleCommandHandler handler = mcs.getCommandHandler();
        JsonObject result = new JsonObject();
        try {
            String output = handler.handleCommand(this.command);
            result.add("output", output);
        }
        catch (Throwable e) {
            result.add("output", "Error: " + e.getClass().getSimpleName() + "[" + e.getMessage() + "]");
        }
        root.add("result", result);
    }

    @Override
    public Object readResponse(JsonObject json) {
        return JsonUtil.getString(json, "output", "Error while reading response " + ConsoleCommandRequest.class.getName());
    }

    @Override
    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        root.add("command", this.command);
        return root;
    }

    @Override
    public void fromJson(JsonObject json) {
        this.command = JsonUtil.getString(json, "command", "");
    }
}

