/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.internal.management.request;

import com.att.aft.dme2.hazelcast.com.eclipsesource.json.JsonObject;
import com.att.aft.dme2.hazelcast.instance.HazelcastInstanceImpl;
import com.att.aft.dme2.hazelcast.internal.management.ManagementCenterService;
import com.att.aft.dme2.hazelcast.internal.management.request.ConsoleRequest;
import com.att.aft.dme2.hazelcast.logging.ILogger;
import com.att.aft.dme2.hazelcast.util.JsonUtil;
import java.io.IOException;

public class ForceStartNodeRequest
implements ConsoleRequest {
    public static final String SUCCESS_RESULT = "SUCCESS";
    public static final String FAILED_RESULT = "FAILED";

    @Override
    public int getType() {
        return 37;
    }

    @Override
    public Object readResponse(JsonObject in) throws IOException {
        return JsonUtil.getString(in, "result", "FAIL");
    }

    @Override
    public void writeResponse(ManagementCenterService mcs, JsonObject out) throws Exception {
        String resultString;
        HazelcastInstanceImpl instance = mcs.getHazelcastInstance();
        try {
            resultString = instance.node.getNodeExtension().triggerForceStart() ? SUCCESS_RESULT : FAILED_RESULT;
        }
        catch (Exception e) {
            ILogger logger = instance.node.getLogger(this.getClass());
            logger.warning("Problem on force start: ", e);
            resultString = e.getMessage();
        }
        JsonObject result = new JsonObject().add("result", resultString);
        out.add("result", result);
    }

    @Override
    public JsonObject toJson() {
        return new JsonObject();
    }

    @Override
    public void fromJson(JsonObject json) {
    }
}

