/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.internal.management.request;

import com.att.aft.dme2.hazelcast.com.eclipsesource.json.JsonObject;
import com.att.aft.dme2.hazelcast.config.MapConfig;
import com.att.aft.dme2.hazelcast.core.Member;
import com.att.aft.dme2.hazelcast.internal.management.ManagementCenterService;
import com.att.aft.dme2.hazelcast.internal.management.dto.MapConfigDTO;
import com.att.aft.dme2.hazelcast.internal.management.operation.GetMapConfigOperation;
import com.att.aft.dme2.hazelcast.internal.management.operation.UpdateMapConfigOperation;
import com.att.aft.dme2.hazelcast.internal.management.request.ConsoleRequest;
import com.att.aft.dme2.hazelcast.util.JsonUtil;
import java.util.Set;

public class MapConfigRequest
implements ConsoleRequest {
    private String mapName;
    private MapConfigDTO config;
    private boolean update;

    public MapConfigRequest() {
    }

    public MapConfigRequest(String mapName, MapConfigDTO config, boolean update) {
        this.mapName = mapName;
        this.config = config;
        this.update = update;
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public void writeResponse(ManagementCenterService mcs, JsonObject root) {
        JsonObject result = new JsonObject();
        result.add("update", this.update);
        if (this.update) {
            Set<Member> members = mcs.getHazelcastInstance().getCluster().getMembers();
            for (Member member : members) {
                mcs.callOnMember(member, new UpdateMapConfigOperation(this.mapName, this.config.getMapConfig()));
            }
            result.add("updateResult", "success");
        } else {
            MapConfig cfg = (MapConfig)mcs.callOnThis(new GetMapConfigOperation(this.mapName));
            if (cfg != null) {
                result.add("hasMapConfig", true);
                result.add("mapConfig", new MapConfigDTO(cfg).toJson());
            } else {
                result.add("hasMapConfig", false);
            }
        }
        root.add("result", result);
    }

    @Override
    public Object readResponse(JsonObject json) {
        this.update = JsonUtil.getBoolean(json, "update", false);
        if (!this.update) {
            boolean hasMapConfig = JsonUtil.getBoolean(json, "hasMapConfig", false);
            if (hasMapConfig) {
                MapConfigDTO adapter = new MapConfigDTO();
                adapter.fromJson(JsonUtil.getObject(json, "mapConfig"));
                return adapter.getMapConfig();
            }
            return null;
        }
        return JsonUtil.getString(json, "updateResult");
    }

    @Override
    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        root.add("mapName", this.mapName);
        root.add("update", this.update);
        root.add("config", this.config.toJson());
        return root;
    }

    @Override
    public void fromJson(JsonObject json) {
        this.mapName = JsonUtil.getString(json, "mapName");
        this.update = JsonUtil.getBoolean(json, "update");
        this.config = new MapConfigDTO();
        this.config.fromJson(JsonUtil.getObject(json, "config"));
    }
}

