/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.internal.management.request;

import com.att.aft.dme2.hazelcast.com.eclipsesource.json.JsonObject;
import com.att.aft.dme2.hazelcast.internal.management.ManagementCenterService;
import com.att.aft.dme2.hazelcast.internal.management.operation.ThreadDumpOperation;
import com.att.aft.dme2.hazelcast.internal.management.request.ConsoleRequest;
import com.att.aft.dme2.hazelcast.util.JsonUtil;

public class ThreadDumpRequest
implements ConsoleRequest {
    private boolean dumpDeadlocks;

    public ThreadDumpRequest() {
    }

    public ThreadDumpRequest(boolean dumpDeadlocks) {
        this.dumpDeadlocks = dumpDeadlocks;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public void writeResponse(ManagementCenterService mcs, JsonObject root) {
        JsonObject result = new JsonObject();
        String threadDump = (String)mcs.callOnThis(new ThreadDumpOperation(this.dumpDeadlocks));
        if (threadDump != null) {
            result.add("hasDump", true);
            result.add("dump", threadDump);
        } else {
            result.add("hasDump", false);
        }
        root.add("result", result);
    }

    @Override
    public String readResponse(JsonObject json) {
        boolean hasDump = JsonUtil.getBoolean(json, "hasDump", false);
        if (hasDump) {
            return JsonUtil.getString(json, "dump");
        }
        return null;
    }

    @Override
    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        root.add("dumpDeadlocks", this.dumpDeadlocks);
        return root;
    }

    @Override
    public void fromJson(JsonObject json) {
        this.dumpDeadlocks = JsonUtil.getBoolean(json, "dumpDeadlocks", false);
    }
}

