/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.internal.memory.impl;

import com.att.aft.dme2.hazelcast.internal.memory.impl.UnsafeUtil;
import java.nio.ByteOrder;

public final class AlignmentUtil {
    public static final int OBJECT_REFERENCE_ALIGN = UnsafeUtil.UNSAFE.arrayIndexScale(Object[].class);
    public static final int OBJECT_REFERENCE_MASK = OBJECT_REFERENCE_ALIGN - 1;
    public static final boolean IS_PLATFORM_BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;

    private AlignmentUtil() {
    }

    public static boolean is2BytesAligned(long address) {
        return (address & 1L) == 0L;
    }

    public static boolean is4BytesAligned(long address) {
        return (address & 3L) == 0L;
    }

    public static boolean is8BytesAligned(long address) {
        return (address & 7L) == 0L;
    }

    public static boolean isReferenceAligned(long address) {
        return (address & (long)OBJECT_REFERENCE_MASK) == 0L;
    }

    public static void checkReferenceAligned(long address) {
        if (!AlignmentUtil.isReferenceAligned(address)) {
            throw new IllegalArgumentException("Memory access to object references must be " + OBJECT_REFERENCE_ALIGN + "-bytes aligned, but the address used was " + address);
        }
    }

    public static void check2BytesAligned(long address) {
        if (!AlignmentUtil.is2BytesAligned(address)) {
            throw new IllegalArgumentException("Atomic memory access must be aligned, but the address used was " + address);
        }
    }

    public static void check4BytesAligned(long address) {
        if (!AlignmentUtil.is4BytesAligned(address)) {
            throw new IllegalArgumentException("Atomic memory access must be aligned, but the address used was " + address);
        }
    }

    public static void check8BytesAligned(long address) {
        if (!AlignmentUtil.is8BytesAligned(address)) {
            throw new IllegalArgumentException("Atomic memory access must be aligned, but the address used was " + address);
        }
    }

    public static boolean isUnalignedAccessAllowed() {
        String arch = System.getProperty("os.arch");
        return arch.equals("i386") || arch.equals("x86") || arch.equals("amd64") || arch.equals("x86_64");
    }
}

