/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.internal.metrics.metricsets;

import com.att.aft.dme2.hazelcast.internal.metrics.DoubleProbeFunction;
import com.att.aft.dme2.hazelcast.internal.metrics.LongProbeFunction;
import com.att.aft.dme2.hazelcast.internal.metrics.MetricsRegistry;
import com.att.aft.dme2.hazelcast.internal.metrics.ProbeLevel;
import com.att.aft.dme2.hazelcast.util.Preconditions;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;

public final class OperatingSystemMetricSet {
    private static final double PERCENTAGE_MULTIPLIER = 100.0;
    private static final Object[] EMPTY_ARGS = new Object[0];

    private OperatingSystemMetricSet() {
    }

    public static void register(MetricsRegistry metricsRegistry) {
        Preconditions.checkNotNull(metricsRegistry, "metricsRegistry");
        OperatingSystemMXBean mxBean = ManagementFactory.getOperatingSystemMXBean();
        OperatingSystemMetricSet.registerMethod(metricsRegistry, mxBean, "getCommittedVirtualMemorySize", "os.committedVirtualMemorySize");
        OperatingSystemMetricSet.registerMethod(metricsRegistry, mxBean, "getFreePhysicalMemorySize", "os.freePhysicalMemorySize");
        OperatingSystemMetricSet.registerMethod(metricsRegistry, mxBean, "getFreeSwapSpaceSize", "os.freeSwapSpaceSize");
        OperatingSystemMetricSet.registerMethod(metricsRegistry, mxBean, "getProcessCpuTime", "os.processCpuTime");
        OperatingSystemMetricSet.registerMethod(metricsRegistry, mxBean, "getTotalPhysicalMemorySize", "os.totalPhysicalMemorySize");
        OperatingSystemMetricSet.registerMethod(metricsRegistry, mxBean, "getTotalSwapSpaceSize", "os.totalSwapSpaceSize");
        OperatingSystemMetricSet.registerMethod(metricsRegistry, mxBean, "getMaxFileDescriptorCount", "os.maxFileDescriptorCount");
        OperatingSystemMetricSet.registerMethod(metricsRegistry, mxBean, "getOpenFileDescriptorCount", "os.openFileDescriptorCount");
        OperatingSystemMetricSet.registerMethod(metricsRegistry, mxBean, "getProcessCpuLoad", "os.processCpuLoad");
        OperatingSystemMetricSet.registerMethod(metricsRegistry, mxBean, "getSystemCpuLoad", "os.systemCpuLoad");
        metricsRegistry.register(mxBean, "os.systemLoadAverage", ProbeLevel.MANDATORY, new DoubleProbeFunction<OperatingSystemMXBean>(){

            @Override
            public double get(OperatingSystemMXBean bean) {
                return 100.0 * bean.getSystemLoadAverage();
            }
        });
    }

    static void registerMethod(MetricsRegistry metricsRegistry, Object osBean, String methodName, String name) {
        final Method method = OperatingSystemMetricSet.getMethod(osBean, methodName);
        if (method == null) {
            return;
        }
        if (Long.TYPE.equals(method.getReturnType())) {
            metricsRegistry.register(osBean, name, ProbeLevel.MANDATORY, new LongProbeFunction(){

                public long get(Object bean) throws Exception {
                    return (Long)method.invoke(bean, EMPTY_ARGS);
                }
            });
        } else {
            metricsRegistry.register(osBean, name, ProbeLevel.MANDATORY, new DoubleProbeFunction(){

                public double get(Object bean) throws Exception {
                    return (Double)method.invoke(bean, EMPTY_ARGS);
                }
            });
        }
    }

    private static Method getMethod(Object source, String methodName) {
        try {
            Method method = source.getClass().getDeclaredMethod(methodName, new Class[0]);
            method.setAccessible(true);
            return method;
        }
        catch (Exception e) {
            return null;
        }
    }
}

